<?php
// Silence is golden.
$args = [
    'title'    => esc_html__('Content', 'fortis'),
    'sections' => [
        'general' => [
            'title' => esc_html__('General', 'fortis'),
            'fields' => [
                'content_width' => fortis_theme_content_width_opts(),
                'search_field_placeholder' => [
                    'type'        => Theme_Core_Options::TEXT_FIELD,
                    'title'       => esc_html__('Search Form - Text Placeholder', 'fortis'),
                    'description' => esc_html__('Default: Search Keywords...', 'fortis'),
                ]
            ]
        ],
        'archive' => [
            'title'  => esc_html__('Archive', 'fortis'),
            'fields' => [
                'archive_author_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Author', 'fortis'),
                    'subtitle' => esc_html__('Show author name on each post.', 'fortis'),
                    'default'  => 1,
                ],
                'archive_date_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Date', 'fortis'),
                    'subtitle' => esc_html__('Show date posted on each post.', 'fortis'),
                    'default'  => 1,
                ],
                'archive_categories_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Categories', 'fortis'),
                    'subtitle' => esc_html__('Show category names on each post.', 'fortis'),
                    'default'  => 1,
                ],
                'archive_comments_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Comments', 'fortis'),
                    'subtitle' => esc_html__('Show comments count on each post.', 'fortis'),
                    'default'  => 1,
                ]
            ],
        ],
        'single-post' => [
            'title'  => esc_html__('Single Post', 'fortis'),
            'fields' => [
                'post_author_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Author', 'fortis'),
                    'subtitle' => esc_html__('Show author name on single post.', 'fortis'),
                    'default'  => 1,
                ],
                'post_author_info_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Author Info', 'fortis'),
                    'subtitle' => esc_html__('Show author info on single post.', 'fortis'),
                ],
                'post_date_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Date', 'fortis'),
                    'subtitle' => esc_html__('Show date on single post.', 'fortis'),
                    'default'  => 1,
                ],
                'post_categories_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Categories', 'fortis'),
                    'subtitle' => esc_html__('Show category names on single post.', 'fortis'),
                    'default'  => 1,
                ],
                'post_tags_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Tags', 'fortis'),
                    'subtitle' => esc_html__('Show tag names on single post.', 'fortis'),
                    'default'  => 1,
                ],
                'post_comments_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Comments', 'fortis'),
                    'subtitle' => esc_html__('Show comments count on single post.', 'fortis'),
                    'default'  => 1,
                ],
                'post_social_share_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Social Share', 'fortis'),
                    'subtitle' => esc_html__('Show social share on single post.', 'fortis')
                ],
                'post_navigation_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Navigation', 'fortis'),
                    'subtitle' => esc_html__('Show navigation on single post.', 'fortis'),
                    'default'  => 1,
                ],
                'post_comments_form_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Comments Form', 'fortis'),
                    'subtitle' => esc_html__('Show comments form on single post.', 'fortis'),
                    'default'  => 1,
                ]
            ]
        ]
    ]
];
return $args;