<?php
// Silence is golden.
$args = [
    'title' => esc_html__('General','fortis'),
    'sections' => [
        'colors' => [
            'title' => esc_html__('Colors', 'fortis'),
            'fields' => [
                'primary_color' => [
                    'type'        => Theme_Core_Options::COLOR_FIELD,
                    'title'       => esc_html__('Primary Color', 'fortis'),
                    'description' => sprintf('%s %s', esc_html__('Default', 'fortis'), fortis_configs('theme_colors')['primary']['value'])
                ],
                'secondary_color' => [
                    'type'        => Theme_Core_Options::COLOR_FIELD,
                    'title'       => esc_html__('Secondary Color', 'fortis'),
                    'description' => sprintf('%s %s', esc_html__('Default', 'fortis'), fortis_configs('theme_colors')['secondary']['value'])
                ],
                'heading_color' => array(
                    'type'    => Theme_Core_Options::COLOR_SET_FIELD,
                    'title'   => esc_html__('Heading Color', 'fortis'),
                    'options' => [
                        'regular' => sprintf('%s (%s)', esc_html__('Default','fortis'), fortis_configs('heading')['color']),
                        'darken'  => sprintf('%s (%s)', esc_html__('Darken','fortis'), fortis_configs('heading')['darken-color']),
                        'lighten' => sprintf('%s (%s)', esc_html__('Lighten','fortis'), fortis_configs('heading')['lighten-color']),
                    ],
                    'default' => [
                        'regular' => '',
                        'darken'  => '',
                        'lighten' => ''
                    ]
                ),
                'link_color' => [
                    'type' => Theme_Core_Options::LINK_COLOR_FIELD,
                    'title' => esc_html__('Link Color', 'fortis')
                ]
            ]
        ],
        'typos' => fortis_typography_opts(),
        'tools' => [
            'title'  => esc_html__('Tools', 'fortis'),
            'fields' => [
                'show_page_loading' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Enable Page Loading', 'fortis'),
                    'subtitle' => esc_html__('Enable page loading effect when you load site.', 'fortis'),
                ],
                'back_totop_on' => [
                    'type'     => Theme_Core_Options::SWITCH_FIELD,
                    'title'    => esc_html__('Back to Top Button', 'fortis'),
                    'subtitle' => esc_html__('Show back to top button when scrolled down.', 'fortis'),
                    'default'  => 1,
                ],
                'dev_mode' => [
                    'type'        => Theme_Core_Options::SWITCH_FIELD,
                    'title'       => esc_html__('Dev Mode (not recommended)', 'fortis'),
                    'description' => esc_html__('no minimize , generate css over time...', 'fortis'),
                ],
            ],
        ]
    ]
];
return $args;