<?php
// Silence is golden.
$args = [
    'title'    => esc_html__('Header', 'fortis'),
    'sections' => [
        'general' => [
            'title' => esc_html__('General', 'fortis'),
            'fields' => [
                'header_layout' => fortis_theme_header_layout_opts([
                    'default'       => $default,
                    'default_value' => $default_value
                ]),
                'main_menu_color' => [
                    'type'  => Theme_Core_Options::LINK_COLOR_FIELD,
                    'title' => esc_html__('Menu Color', 'fortis')
                ],
                'header_height' => [
                    'type'     => 'dimensions',
                    'title'    => esc_html__('Header Height', 'fortis'),
                    'subtitle' => esc_html__('Set height for your Header', 'fortis'),
                    'width'    => false
                ],
                'extra' => [
                    'type'  => Theme_Core_Options::HEADING_FIELD,
                    'title' => esc_html__('Extra Settings', 'fortis')
                ],
                'header_sticky' => fortis_theme_on_off_opts([
                    'title'         => esc_html__('Header Sticky', 'fortis'),
                    'subtitle'      => esc_html__('Header will be sticked when applicable.', 'fortis')
                ]),
                'header_width' => fortis_theme_content_width_opts([
                    'title'         => esc_html__('Header Content Width', 'fortis'),
                    'default'       => $default,
                    'default_value' => $default_width
                ])
            ]
        ],
        'logo' => [
            'title'  => esc_html__('Logo', 'fortis'),
            'fields' => [
                'logo' => [
                    'type'  => Theme_Core_Options::MEDIA_FIELD,
                    'title' => esc_html__('Logo', 'fortis')
                ],
                'logo_maxh' => [
                    'type'     => 'dimensions',
                    'title'    => esc_html__('Logo Dimensions', 'fortis'),
                    'subtitle' => esc_html__('Enter number.', 'fortis')
                ],
                'logo_mobile' => [
                    'type'  => Theme_Core_Options::MEDIA_FIELD,
                    'title' => esc_html__('Logo Tablet & Mobile', 'fortis')
                ],
                'logo_maxh_sm' => [
                    'type'     => 'dimensions',
                    'title'    => esc_html__('Logo Tablet & Mobile Dimensions', 'fortis'),
                    'subtitle' => esc_html__('Enter number.', 'fortis')
                ],
            ],
        ],
        'header_ontop' => [
            'title' => esc_html__('Header Transparent', 'fortis'),
            'fields' => [
                'header_transparent' => fortis_theme_on_off_opts([
                    'title'         => esc_html__('Header Transparent', 'fortis'),
                    'subtitle'      => esc_html__('Header transparent use with background.', 'fortis'),
                    'default_value' => $default_off
                ]),
                'logo_light' => [
                    'type' => Theme_Core_Options::MEDIA_FIELD,
                    'title' => esc_html__('Logo', 'fortis')
                ],
                'logo_light_mobile' => [
                    'type'  => Theme_Core_Options::MEDIA_FIELD,
                    'title' => esc_html__('Logo Tablet & Mobile', 'fortis')
                ],
                'transparent_menu_color' => [
                    'type' => Theme_Core_Options::LINK_COLOR_FIELD,
                    'title' => esc_html__('Menu Color', 'fortis')
                ]
            ]
        ],
        'attributes' => [
            'title' => esc_html__('Attributes','fortis'),
            'fields' => array_merge(
                [
                    'search_icon' => fortis_theme_on_off_opts([
                        'title'         => esc_html__('Search Icon', 'fortis'),
                        'default'       => $default,
                        'default_value' => $default_off
                    ]),
                    'cart_icon' => fortis_theme_on_off_opts([
                        'title'         => esc_html__('Cart Icon', 'fortis'),
                        'default'       => $default,
                        'default_value' => $default_off
                    ])
                ],
                fortis_theme_phone_settings([
                    'default'       => $default,
                    'default_value' => $default_off 
                ]),
                fortis_theme_button_settings([
                    'default'       => $default,
                    'default_value' => $default_off 
                ]),
                fortis_theme_button_settings([
                    'heading'       => esc_html__('Button Settings #2', 'fortis'),
                    'name'          => 'h_btn2',
                    'default'       => $default,
                    'default_value' => $default_off 
                ])
            )
        ]
    ]
];
return $args;