<?php
// Silence is golden.
$fields_default = [
    'pagetitle' => fortis_theme_show_hide_opts([
        'title'         => esc_html__('Page Title', 'fortis'),
        'default'       => $default,
        'default_value' => $default_on,
        'required' => [
            'custom_ptitle',
            '=',
            'on'
        ]
    ]),
    'show_title' => fortis_theme_show_hide_opts([
        'title'         => esc_html__('Title', 'fortis'),
        'default'       => $default,
        'default_value' => $default_on,
        'required'      => [
            'pagetitle',
            '=',
            'on'
        ]
    ]),
    'show_breadcrumb' => fortis_theme_show_hide_opts([
        'title'         => esc_html__('Breadcrumbs', 'fortis'),
        'default'       => $default,
        'default_value' => $default_on,
        'required'      => [
            'pagetitle',
            '=',
            'on'
        ]
    ]),
    'ptitle_align'  => fortis_them_content_align_opts([
        'required'      => [
            'pagetitle',
            '=',
            'on'
        ]
    ]),
    'ptitle_heading' => [
        'type'     => Theme_Core_Options::HEADING_FIELD,
        'title'    => esc_html__('Background Settings', 'fortis'),
        'required' => [
            'pagetitle',
            '=',
            'on'
        ]
    ],
    'page_title_bg' => [
        'type'     => Theme_Core_Options::BACKGROUND_FIELD,
        'title'    => esc_html__('Background', 'fortis'),
        'subtitle' => esc_html__('Choose Background color and image', 'fortis'),
        'required' => [
            'pagetitle',
            '=',
            'on'
        ],
        'background-repeat'     => false,
        'background-size'       => false,
        'background-position'   => false,
        'background-attachment' => false
    ],
    'page_title_overlay' => [
        'type'     => Theme_Core_Options::RGBA_COLOR_FIELD,
        'title'    => esc_html__('Overlay Background Color', 'fortis'),
        'required' => [
            'pagetitle',
            '=',
            'on'
        ]
    ]
];
$fields = [];
if($custom_opts){
    $fields = [
        'custom_ptitle' => fortis_theme_on_off_opts([
            'title'         => esc_html__('Custom Page Title','fortis'),
            'default'       => false,
            'default_value' => 'off'
        ])
    ];
}
$args = [
    'title'  => esc_html__('Page Tile', 'fortis'),
    'fields' => $fields + $fields_default
];
return $args;