<?php
// Silence is golden.
$args = [
    'title'    => esc_html__('Sidebar', 'fortis'),
    'sections' => [
        'general' => [
            'title' => esc_html__('General', 'fortis'),
            'fields' => [
                'sidebar_on' => fortis_theme_show_hide_opts([
                    'title'    => esc_html__('Show Sidebar', 'fortis'),
                    'subtitle' => esc_html__('Show/Hide sidebar on single post & archive page', 'fortis')
                ]),
                'sidebar_pos' => [
                    'type'    => Theme_Core_Options::BUTTON_SET_FIELD,
                    'title'   => esc_html__('Sidebar Position','fortis'),
                    'options' => [
                        'order-first' => esc_html__('Left','fortis'),
                        'order-last'  => esc_html__('Right','fortis')
                    ],
                    'default' => 'order-last',
                    'required' => [
                        'sidebar_on', '=', 'on'
                    ]
                ]
            ]
        ]
    ]
];
return $args;