<?php
if (class_exists('Theme_Core_Options')) {
    // Set Location of Theme Options Menu
    add_filter('tco_page_parent', 'fortis_tco_parent_page');
    function fortis_tco_parent_page()
    {
        $current_theme = wp_get_theme();
        if (is_child_theme()) {
            $current_theme = $current_theme->parent();
        }
        return $current_theme->get('TextDomain');
    }

    // Set Theme Options Name
    add_filter('tco_theme_options_name', 'fortis_tco_theme_options_name');
    add_filter('swa_ie_options_name', 'fortis_tco_theme_options_name');
    function fortis_tco_theme_options_name()
    {
        $opt_name = fortis_get_opt_name();
        return $opt_name;
    }

    add_filter('tco_theme_options_args', 'fortis_theme_options_args');

    function fortis_theme_options_args()
    {
        $default        = false;
        $default_value  = '1';
        $default_layout = '1';
        $default_on     = 'on';
        $default_off    = 'off';
        $default_width  = 'container';
        $custom_opts    = false;

        $general     = include get_template_directory() . '/inc/theme-options/args/general.php';
        $header_top  = include get_template_directory() . '/inc/theme-options/args/header-top.php';
        $header      = include get_template_directory() . '/inc/theme-options/args/header.php';
        $page_title  = include get_template_directory() . '/inc/theme-options/args/page-title.php';
        $content     = include get_template_directory() . '/inc/theme-options/args/content.php';
        $sidebar     = include get_template_directory() . '/inc/theme-options/args/sidebar.php';
        $shop        = include get_template_directory() . '/inc/theme-options/args/shop.php';
        $footer      = include get_template_directory() . '/inc/theme-options/args/footer.php';
        $api         = include get_template_directory() . '/inc/theme-options/args/api.php';
        $page_404    = include get_template_directory() . '/inc/theme-options/args/404-page.php';

        $args = [
            'general'     => $general,
            'header_top'  => $header_top,
            'header'      => $header,
            'page-title'  => $page_title,
            'content'     => $content,
            'sidebar'     => $sidebar,  
            'footer'      => $footer,
            '404-page'    => $page_404,
        ];
        if(class_exists('WooCommerce')){
            $args['shop'] =  $shop;
        }
        $args['api'] = $api;

        return $args;
    }
}
/**
 * Get post thumbnail as image options
 * @return array
 *
*/
function fortis_list_post_thumbnail($post_type = 'post', $default = false, $args = []){
    $layouts = [];
    if($default){
        $layouts['-1'] = get_template_directory_uri() . '/assets/images/default-opt/default.jpg';
        $layouts['none'] = get_template_directory_uri() . '/assets/images/default-opt/none.jpg';
    }
    $layouts = array_unique($layouts + $args);
    $posts = get_posts(array('post_type' => $post_type,'posts_per_page' => '-1'));
    
    foreach($posts as $post){
        $layouts[$post->ID] = wp_get_attachment_image_url(get_post_thumbnail_id($post->ID), 'full');
    }
    return $layouts;
}
/**
 * Typography
**/
if(!function_exists('fortis_typography_opts')){
    function fortis_typography_opts($args = []){
        $default = [
            'body_font' => [
                'type'        => Theme_Core_Options::SELECT_FIELD,
                'title'       => esc_html__('Body Font', 'fortis'),
                'options'     => [
                    'default' => esc_html__('Default', 'fortis'),
                    'custom'  => esc_html__('Custom', 'fortis'),
                ],
                'default'     => 'default'
            ],
            'body_font_typo' => [
                'type'     => Theme_Core_Options::TYPOGRAPHY_FIELD,
                'title'    => esc_html__('Body Custom Font', 'fortis'),
                'subtitle' => esc_html__('This will be the default font of your website.', 'fortis'),
                'required' => [
                    'body_font',
                    '=',
                    'custom'
                ],
                'font_backup'  => false,
                'font_subsets' => false,
                'font_style'   => true, 
                'line_height'  => false,
                'font_size'    => false,
                'color'        => false,
                'output'         => ['body']
            ],
            'heading_font' => [
                'type'    => Theme_Core_Options::SELECT_FIELD,
                'title'   => esc_html__('Heading Default Font', 'fortis'),
                'options' => [
                    'default' => esc_html__('Default', 'fortis'),
                    'custom'  => esc_html__('Google Font', 'fortis'),
                ],
                'default' => 'default'
            ],
            'heading_font_typo' => [
                'type'     => Theme_Core_Options::TYPOGRAPHY_FIELD,
                'title'    => esc_html__('Heading', 'fortis'),
                'subtitle' => esc_html__('This will be the default font for all Heading tags of your website.', 'fortis'),
                'output'   => [
                    //'h1,h2,h3,h4,h5,h6,.h1,.h2,.h3,.h4,.h5,.h6,.heading, .cms-heading'
                ],
                'required' => [
                    'heading_font',
                    '=',
                    'custom',
                ],
                'font_backup'  => false,
                'font_subsets' => false,
                'font_style'   => true,
                'line_height'  => true,
                'font_size'    => false,
                'color'        => false,    
            ]
        ];
        return [
            'title'  => esc_html__('Typographys', 'fortis'),
            'fields' => array_merge($default, $args)
        ];
    }
}
if(!function_exists('fortis_general_advanced_opts')){
    function fortis_general_advanced_opts($args = []){
        $default = [
            'btn_style' => [
                'type'        => Theme_Core_Options::SELECT_FIELD,
                'title'       => esc_html__('Button Style', 'fortis'),
                'options'     => [
                    'btn-style-default' => esc_html__('Default', 'fortis'),
                    'btn-style-rounded' => esc_html__('Rounded', 'fortis'),
                    'btn-style-rounded5' => esc_html__('Rounded (5px)', 'fortis'),
                ],
                'default' => 'btn-style-default'
            ]
        ];
        return [
            'title'  => esc_html__('Advanced', 'fortis'),
            'fields' => array_merge($default, $args)
        ];
    }
}
/**
 * ON/ OFF option
 * 
 * */
function fortis_theme_on_off_opts($args = []){
    $args = wp_parse_args($args, [
        'default'       => false,
        'default_value' => 'off',
        'title'         => esc_html__('On/Off', 'fortis'),
        'subtitle'      => '',
        'required'      => ''
    ]);
    $opts = [
        'on' => esc_html__('On', 'fortis'),
        'off' => esc_html__('Off', 'fortis'),
    ];
    if($args['default']) {
        $opts['-1'] = esc_html__('Default','fortis');
        $args['default_value'] = '-1';
    }
    return [
        'type'     => Theme_Core_Options::BUTTON_SET_FIELD,
        'title'    => $args['title'],
        'subtitle' => $args['subtitle'],
        'options'  => $opts,
        'default'  => $args['default_value'],
        'required' => $args['required']
    ];
}
/**
 * Show/ Hide option
 * 
 * */
function fortis_theme_show_hide_opts($args = []){
    $args = wp_parse_args($args, [
        'default'       => false,
        'default_value' => 'off',
        'title'         => esc_html__('Show/Hide', 'fortis'),
        'subtitle'      => '',
        'required'      => ''    
    ]);
    $opts = [
        'on' => esc_html__('Show', 'fortis'),
        'off' => esc_html__('Hide', 'fortis'),
    ];
    if($args['default']) {
        $opts['-1'] = esc_html__('Default','fortis');
        $args['default_value'] = '-1';
    }
    return [
        'type'     => Theme_Core_Options::BUTTON_SET_FIELD,
        'title'    => $args['title'],
        'subtitle' => $args['subtitle'],
        'options'  => $opts,
        'default'  => $args['default_value'],
        'required' => $args['required']
    ];
}
/**
 * Content Width
 * 
 * */
function fortis_theme_content_width_opts($args = []){
    $args = wp_parse_args($args, [
        'default'       => false,
        'default_value' => 'container',
        'title'         => esc_html__('Content Width','fortis'),
        'subtitle'      => '',
        'required'      => ''
    ]);
    $opts = [
        'container'       => esc_html__('Container', 'fortis'),
        'container-wide'  => esc_html__('Container Wide', 'fortis'),
        'container-fluid' => esc_html__('Container Fluid', 'fortis'),
        'container--full'  => esc_html__('Container Full', 'fortis')
    ];
    if($args['default']) {
        $opts['-1'] = esc_html__('Default','fortis');
        $args['default_value'] = '-1';
    }
    return [
        'type'     => Theme_Core_Options::BUTTON_SET_FIELD,
        'title'    => $args['title'],
        'subtitle' => $args['subtitle'],
        'options'  => $opts,
        'default'  => $args['default_value'],
        'required' => $args['required']
    ];
}
function fortis_theme_content_width_render($args = []){
    $args = wp_parse_args($args, [
        'name'    => '',
        'default' => 'container'
    ]);
    $settings = fortis_get_opts($args['name'], $agrs['default']);
    if(!empty($settings)) return $args['prefix'].$settings;
}
/**
 * Content Alignment
 * **/
function fortis_them_content_align_opts($args = []){
    $args = wp_parse_args($args, [
        'default'       => false,
        'default_value' => '',
        'title'         => esc_html__('Content Alignment','fortis'),
        'subtitle'      => '',
        'required'      => ''
    ]);
    $opts = [
        'start'  => esc_html__('Start', 'fortis'),
        'center' => esc_html__('Center', 'fortis'),
        'end'    => esc_html__('End', 'fortis'),
    ];
    if($args['default']) {
        $opts['-1'] = esc_html__('Default','fortis');
        $args['default_value'] = '-1';
    }
    return [
        'type'     => Theme_Core_Options::BUTTON_SET_FIELD,
        'title'    => $args['title'],
        'subtitle' => $args['subtitle'],
        'options'  => $opts,
        'default'  => $args['default_value'],
        'required' => $args['required']
    ];
}
function fortis_them_content_align_render($args = []){
    $args = wp_parse_args($args, [
        'name'    => '',
        'prefix'  => 'text-',
        'default' => 'start'
    ]);
    $settings = fortis_get_opts($args['name'], $agrs['default']);
    if(!empty($settings)) return $args['prefix'].$settings;
}
/**
 * Button Settings
 * 
 * **/
if(!function_exists('fortis_theme_button_settings')){
    function fortis_theme_button_settings($args = []){
        $args = wp_parse_args($args, [
            'name'          => 'h_btn',
            'heading'       => esc_html__('Button Settings','fortis'),  
            'default'       => false,
            'default_value' => 'off'
        ]);
        return [
            $args['name'].'_heading' => [
                'type' => Theme_Core_Options::HEADING_FIELD,
                'title' => $args['heading'],
            ],
            $args['name'].'_on' => fortis_theme_on_off_opts([
                'default'       => $args['default'],    
                'default_value' => $args['default_value'],
                'title'         => esc_html__('Show/Hide Button', 'fortis')
            ]),
            $args['name'].'_text' => [
                'type' => Theme_Core_Options::TEXT_FIELD,
                'title' => esc_html__('Button Text', 'fortis'),
                'required' => [
                    $args['name'].'_on',
                    '=',
                    'on'
                ],
            ],
            $args['name'].'_link_type' => [
                'type' => Theme_Core_Options::BUTTON_SET_FIELD,
                'title' => esc_html__('Button Link Type', 'fortis'),
                'options' => [
                    'page' => esc_html__('Page', 'fortis'),
                    'custom' => esc_html__('Custom', 'fortis'),
                ],
                'default' => 'page',
                'required' => [
                    $args['name'].'_on',
                    '=',
                    'on'
                ],
            ],
            $args['name'].'_link' => [
                'type' => Theme_Core_Options::SELECT_FIELD,
                'title' => esc_html__('Page Link', 'fortis'),
                'args' => [
                    'post_type' => 'page',
                    'posts_per_page' => -1,
                    'orderby' => 'title',
                    'order' => 'ASC',
                ],
                'select2' => true,
                'required' => [
                    $args['name'].'_link_type',
                    '=',
                    'page'
                ],
            ],
            $args['name'].'_link_custom' => [
                'type' => Theme_Core_Options::TEXT_FIELD,
                'title' => esc_html__('Custom Link', 'fortis'),
                'required' => [
                    $args['name'].'_link_type',
                    '=',
                    'custom'
                ],
            ],
            $args['name'].'_target' => [
                'type' => Theme_Core_Options::BUTTON_SET_FIELD,
                'title' => esc_html__('Button Target', 'fortis'),
                'options' => [
                    '_self' => esc_html__('Self', 'fortis'),
                    '_blank' => esc_html__('Blank', 'fortis'),
                ],
                'default' => '_self',
                'required' => [
                    $args['name'].'_on',
                    '=',
                    'on'
                ],
            ]
        ];
    }
}
/**
 * Phone Settings
 * **/
if(!function_exists('fortis_theme_phone_settings')){
    function fortis_theme_phone_settings($args = []){
        $args = wp_parse_args($args, [
            'name'        => '',
            'default'     => false,  
            'default_opt' => 'off'
        ]);
        return [
            'show_phone'.$args['name'] => [
                'type'  => Theme_Core_Options::HEADING_FIELD,
                'title' => esc_html__('Phone', 'fortis').' '.$args['name'],
            ],
            'h_phone'.$args['name'].'_on' => fortis_theme_on_off_opts([
                'default'       => $args['default'],
                'default_value' => 'off',
                'title'         => esc_html__('Show/Hide Phone', 'fortis').' '.$args['name']
            ]),
            'h_phone'.$args['name'].'_number' => [
                'type'        => Theme_Core_Options::TEXT_FIELD,
                'title'       => esc_html__('Phone Number', 'fortis'),
                'placeholder' => '+2 0106124541',
                'required'    => [
                    'h_phone'.$args['name'].'_on',
                    '=',
                    'on'
                ]
            ]
        ];
    }
}
/**
 * Header layout 
 * 
 * */
if(!function_exists('fortis_theme_header_layout_opts')){
    function fortis_theme_header_layout_opts($args = []){
        $args = wp_parse_args($args, [
            'default'       => false,
            'default_value' => '1',
            'required'      => ''
        ]);
        $header_layout = [];
        if($args['default']){
            $header_layout['-1'] = get_template_directory_uri() . '/assets/images/default-opt/default.jpg';
            $header_layout['none'] = get_template_directory_uri() . '/assets/images/default-opt/default.jpg';
        }
        // Theme Layout
        $layouts = [
            '1' => get_template_directory_uri() . '/assets/images/header-layout/h1.jpg',
            '2' => get_template_directory_uri() . '/assets/images/header-layout/h2.jpg',
            '3' => get_template_directory_uri() . '/assets/images/header-layout/h3.jpg',
            '4' => get_template_directory_uri() . '/assets/images/header-layout/h4.jpg',
            '5' => get_template_directory_uri() . '/assets/images/header-layout/h5.jpg',
            '6' => get_template_directory_uri() . '/assets/images/header-layout/h6.jpg',
            '7' => get_template_directory_uri() . '/assets/images/header-layout/h7.jpg',
            '8' => get_template_directory_uri() . '/assets/images/header-layout/h8.jpg'
        ];
        return [
            'type'     => Theme_Core_Options::IMAGE_SELECT_FIELD,
            'title'    => esc_html__('Layout', 'fortis'),
            'subtitle' => esc_html__('Select a layout for header.', 'fortis'),
            'options'  => array_unique ($header_layout + $layouts),
            'default'  => $args['default_value'],
            'required' => $args['required']
        ];
    }
}
/**
 * Header TOp Options
**/
if(!function_exists('fortis_header_top_opts')){
    function fortis_header_top_opts($args=[]){
        $args = wp_parse_args($args, [
            'default'        => false,
            'default_value'  => '1',
            'default_on'     => 'off',
            'custom'         => false   
        ]);
        if($args['default']){
            $args['default_value'] = '-1';
        }
        $custom_fields = [];
        if($args['custom']){
            $custom_fields['header_top_custom'] = fortis_theme_on_off_opts([
                'title'         => esc_html__('Custom Header Top','fortis'),
                'default'       => false
            ]);
        }
        $default_fields = [
            'header_top_layout' => array(
                'type'        => Theme_Core_Options::IMAGE_SELECT_FIELD,
                'title'       => esc_html__('Layout', 'fortis'),
                'subtitle'    => esc_html__('Select a layout for upper footer area.', 'fortis'),
                'description' => sprintf(esc_html__('%sClick Here%s to add your custom header top layout.','fortis'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=cms-header-top' ) ) . '" target="_blank">','</a>'),
                'placeholder' => esc_html__('Default','fortis'),
                'options'     => fortis_list_post_thumbnail('cms-header-top', $args['default'], [
                    'none' => get_template_directory_uri() . '/assets/images/default-opt/none.jpg'
                ]),
                'default'     => $args['default_value'],
                'required' => [
                    'header_top_custom', "=", 'on'
                ]
            )
        ];
        // Return
        return [
            'title'      => esc_html__('Header Top', 'fortis'),
            'fields'     => $custom_fields + $default_fields
        ];
    }
}
/**
 * Footer Options
**/
if(!function_exists('fortis_footer_opts')){
    function fortis_footer_opts($args=[]){
        $args = wp_parse_args($args, [
            'default'        => false,
            'default_value'  => '1',
            'default_on'     => 'off',
            'custom'         => false   
        ]);
        if($args['default']){
            $args['default_value'] = '-1';
        }
        $custom_fields = [];
        if($args['custom']){
            $custom_fields['footer_custom'] = fortis_theme_on_off_opts([
                'title'         => esc_html__('Custom Footer','fortis'),
                'default'       => false
            ]);
        }
        $default_fields = [
            'footer_layout' => array(
                'type'        => Theme_Core_Options::IMAGE_SELECT_FIELD,
                'title'       => esc_html__('Layout', 'fortis'),
                'subtitle'    => esc_html__('Select a layout for upper footer area.', 'fortis'),
                'description' => sprintf(esc_html__('%sClick Here%s to add your custom footer layout.','fortis'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=cms-footer' ) ) . '" target="_blank">','</a>'),
                'placeholder' => esc_html__('Default','fortis'),
                'options'     => fortis_list_post_thumbnail('cms-footer', $args['default'], [
                    '1' => get_template_directory_uri() . '/assets/images/footer-layout/default.png'
                ]),
                'default'     => $args['default_value'],
                'required' => [
                    'footer_custom', "=", 'on'
                ]
            ),
            'footer_fixed' => fortis_theme_on_off_opts([
                'title'         => esc_html__('Footer Fixed', 'fortis'),
                'subtitle'      => esc_html__('Make footer fixed at bottom?', 'fortis'),
                'default'       => $args['default'],
                'default_value' => $args['default_on'], 
                'required' => [
                    'footer_custom', "=", 'on'
                ]
            ])
        ];
        // Return
        return [
            'title'      => esc_html__('Footer', 'fortis'),
            'fields'     => $custom_fields + $default_fields
        ];
    }
}