<?php
/**
 * Template part for displaying posts in loop
 *
 * @package Fortis
 */
?>
<div class="cms-single cms-shadow-4">
	<?php 
		fortis_entry_thumbnail(['size' => 'large']);
	?>
	<div class="cms-post--content">
		<?php 
			fortis_post_meta([
				'opt_prefix' => 'post_',
				'gap'		 => ''
			]);
			fortis_entry_single_title();
		?>
		<div class="content clearfix"><?php 
			the_content(); 
			fortis_entry_link_pages();
		?></div>
		<div class="tags-share d-flex gap justify-content-between empty-none"><?php 
			fortis_entry_tagged_in(['class' => 'flex-basis']);
			fortis_socials_share_default(['class' => 'flex-auto']);
		?></div>
	</div>
</div>
<?php
	fortis_post_nav_default();
if(!empty(get_the_author_meta( 'description' )) && fortis_get_opt('post_author_info_on', false)){
?>
<div class="cms-author-info d-flex gap text-mobile-center cms-shadow-4" style="--cms-gap:20px;--cms-gap-mobile:20px;">
    <div class="author-avatar flex-auto">
		<?php echo get_avatar( get_the_author_meta( 'ID' ), 120 ); ?>
    </div>
    <div class="author-desc flex-basic flex-mobile-auto">
    	<h4 class="author-name font-500 text-heading-darken"><?php the_author_meta( 'display_name' ); ?></h4>
		<?php 
			the_author_meta( 'description' );
			fortis_get_user_social(); 
		?>
    </div>
</div>
<?php 
	}
?>