<?php
/**
 * Template part for displaying default header layout
 */

$hide_sidebar_icon = fortis_get_opt( 'hide_sidebar_icon', false );
?>
<header id="cms-header-wrap" class="site-header">
    <div id="cms-header" class="<?php echo fortis_header_classes(); ?>">
         <?php fortis_header_top(); ?>
        <div class="<?php echo fortis_header_container_classes('d-flex justify-content-between'); ?>">
            <?php 
            // Side Nav
            if ( $hide_sidebar_icon ) : ?>
                <div class="site-side-nav h-btn-sidebar">
                    <span></span>
                </div>
            <?php endif;
            // logo
            get_template_part('template-parts/header/header-branding', '', [
                'before' => '<div class="site-branding">',
                'after'  => '</div>',
            ]);
            // Navigation 
            get_template_part('template-parts/header/header-menu', '',[
                'before' => '<nav class="site-navigation main-navigation justify-content-end flex-basic">', 
                'after'  => '</nav>' 
            ]);
            ?>
            <div class="site-tools d-flex align-items-center">
                <?php 
                // Search icon
                fortis_header_search();
                // Cart icon
                fortis_header_cart();
                // Phone
                fortis_header_phone_render();
                // Button 01
                fortis_header_button_render([
                    'class' => 'h-btn2 btn btn-sm', 
                    'icon' => '<span class="cms-hidden-wide cmsi-email"></span>'
                ]);
                // Button 02
                fortis_header_button_render([
                    'name' => 'h_btn2',
                    'class' => 'btn btn-sm',
                    'icon' => '<span class="cms-hidden-wide cmsi-external-link rtl-flip"></span>'
                ]);
                ?>
                <div id="main-menu-mobile" class="site-header-item">
                    <span class="btn-nav-mobile open-menu">
                        <span></span>
                    </span>
                </div>
            </div>
        </div>
    </div>
</header>