<?php
/**
 * Template part for displaying default header layout
 */

$hide_sidebar_icon = fortis_get_opt( 'hide_sidebar_icon', false );
?>
<header id="cms-header-wrap" class="site-header">
    <div id="cms-header" class="<?php echo fortis_header_classes(); ?>">
        <?php fortis_header_top(); ?>
        <div class="<?php echo fortis_header_container_classes('d-flex justify-content-between'); ?>">
            <?php 
            // Side Nav
            if ( $hide_sidebar_icon ) : ?>
                <div class="site-side-nav h-btn-sidebar">
                    <span></span>
                </div>
            <?php endif;
            // logo
            get_template_part('template-parts/header/header-branding', '', [
                'before' => '<div class="site-branding">',
                'after'  => '</div>'
            ]);
            // Navigation 
            ob_start();
            ?>
                <div class="site-tools cms-hidden-laptop"><?php 
                    // Search icon
                    fortis_header_search([
                        'class' => 'pl-40'
                    ]);
                    // Cart icon
                    fortis_header_cart([
                        'class' => ''
                    ]);
                ?></div>
            <?php
            $nav_content = ob_get_clean();
            get_template_part('template-parts/header/header-menu', '',[
                'before' => '<nav class="site-navigation main-navigation flex-basic justify-content-center">', 
                'after'  => $nav_content.'</nav>'
            ]);
            ?>
            <div class="site-tools d-flex align-items-center justify-content-between justify-content-tablet-extra-end">
                <div class="site-tools site-tools2 empty-none"><?php 
                    // Search icon
                    fortis_header_search([
                        'class' => 'cms-hidden-wide'
                    ]);
                    // Cart icon
                    fortis_header_cart([
                        'class' => 'cms-hidden-wide'
                    ]);
                    // Phone
                    fortis_header_phone_render([
                        'style' => (fortis_get_opts('header_transparent', 'off', 'header_custom') === 'on') ? 'btn-white-25' : '1',
                        'data'  => [
                            'default'     => 'btn-1',
                            'transparent' => 'btn-white-25'
                        ] 
                    ]);
                    // Button 01
                    fortis_header_button_render([
                        'class' => 'h-btn1 btn btn-sm',
                        'data'  => [
                            'default'     => '',
                            'transparent' => 'btn-hover-white'
                        ],
                        'icon' => '<span class="cms-hidden-wide cmsi-email"></span>'
                    ]);
                    // Button 02
                    fortis_header_button_render([
                        'name'  => 'h_btn2', 
                        'class' => 'h-btn2 btn btn-sm',
                        'data'  => [
                            'default'     => 'btn-secondary btn-hover-primary',
                            'transparent' => 'btn-secondary btn-hover-white'
                        ],
                        'icon' => '<span class="cms-hidden-wide cmsi-arrow-right"></span>'
                    ]);
                    ?>
                    <div id="main-menu-mobile" class="site-header-item">
                        <span class="btn-nav-mobile open-menu">
                            <span></span>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>