<?php
//
$titles = fortis_get_page_titles();
ob_start();
if ( $titles['title'] ) {
	printf( '<h1 class="title font-600">%s</h1>', wp_kses_post( $titles['title'] ) );
}
$titles_html = ob_get_clean();

$breadcrumb_align = is_singular('product') ? 'start' : $args['ptitle_align'];

?>
<?php if ( ( (is_singular( 'post' ) || is_singular('product')) && $args['show_breadcrumb'] == 'on' ) ) { ?>
    <div id="cms-ptitle" class="<?php echo esc_attr($args['class']); ?> single-post">
        <div class="<?php echo esc_attr($args['container']); ?> relative z-top">
			<?php fortis_breadcrumb(['class' => 'cms-breadcrumb-1 justify-content-'.$breadcrumb_align]); ?>
        </div>
    </div>
<?php } else { ?>
    <div id="cms-ptitle" class="<?php echo esc_attr($args['class']); ?>">
		<div class="<?php echo esc_attr($args['container']); ?> relative z-top">
			<?php if ($args['show_title'] == 'on') printf( '%s', wp_kses_post( $titles_html ) ); ?>
			<?php if ($args['show_breadcrumb'] == 'on') fortis_breadcrumb(['class' => 'justify-content-'.$args['ptitle_align']]); ?>
        </div>
    </div>
<?php } ?>