<?php
add_filter( 'woocommerce_get_image_size_single', function ( $size ) {
    $size['width']  = 600;
    $size['height'] = 600;
    $size['crop']   = 1;
    return $size;
} );

/**
 * Loop Products
 * 
 * */
// Loops Product Columns
add_filter( 'loop_shop_columns', 'fortis_loop_shop_columns', 20 ); 
function fortis_loop_shop_columns() {
  $columns = fortis_get_opt('shop_loop_columns', 4);
  if(is_active_sidebar('sidebar-product')) {
    $columns = $columns - 1 ; //- 1;
  } else {
    $columns = $columns ; //- 1;
  }
  return $columns;
}
add_filter('loop_shop_per_page', 'fortis_loop_shop_per_page');
function fortis_loop_shop_per_page(){
    return fortis_loop_shop_columns()*3;
}
// remove shop title
add_filter('woocommerce_show_page_title', function (){ return false;});
// Wrap Result Count / Catalog Ordering in div
add_action('woocommerce_before_shop_loop', function() {echo '<div class="cms-result-order w-100 d-flex justify-content-between align-items-center">';}, 19);
add_action('woocommerce_before_shop_loop', function() {echo '</div>'; }, 31);

// Products image size
add_filter( 'woocommerce_get_image_size_gallery_thumbnail', function ( $size ) {
    $size['width']  = 300;
    $size['height'] = 300;
    $size['crop']   = 1;

    return $size;
} );

// wrap produc image in a div
add_action('woocommerce_before_shop_loop_item_title','fortis_woocommerce_before_shop_loop_item_title_open',-1);
if(!function_exists('fortis_woocommerce_before_shop_loop_item_title_open')){
    function fortis_woocommerce_before_shop_loop_item_title_open(){
        echo '<div class="cms-products-loop-thumbs relative">';
    }
}
add_action('woocommerce_before_shop_loop_item_title','fortis_woocommerce_before_shop_loop_item_title_close',999);
if(!function_exists('fortis_woocommerce_before_shop_loop_item_title_close')){
    function fortis_woocommerce_before_shop_loop_item_title_close(){
        echo '</div>'; // close .cms-products-loop-thumbs
    }
}

// change loop add_to_cart position
remove_action('woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
add_action('woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_add_to_cart',1);
// Change loop add_to_cart Classes
if(!function_exists('fortis_woocommerce_loop_add_to_cart_args')){
  add_filter('woocommerce_loop_add_to_cart_args', 'fortis_woocommerce_loop_add_to_cart_args');
  function fortis_woocommerce_loop_add_to_cart_args($args){
    global $product;
    $args['class'] = implode(
      ' ',
      array_filter(
        array(
          'button btn-lg cms-loop-atc',
          'product_type_' . $product->get_type(),
          $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
          $product->supports( 'ajax_add_to_cart' ) && $product->is_purchasable() && $product->is_in_stock() ? 'ajax_add_to_cart' : '',
        )
      )
    );
    return $args;
  }
}
// Change loop add_to_cart HTML
add_filter('woocommerce_loop_add_to_cart_link', 'fortis_woocommerce_loop_add_to_cart_link', 10, 3);
if(!function_exists('fortis_woocommerce_loop_add_to_cart_link')){
    function fortis_woocommerce_loop_add_to_cart_link($button, $product, $args){
        return sprintf(
            '<a href="%s" data-quantity="%s" class="%s" %s>%s</a>',
            esc_url( $product->add_to_cart_url() ),
            esc_attr( isset( $args['quantity'] ) ? $args['quantity'] : 1 ),
            esc_attr( isset( $args['class'] ) ? $args['class'] : '' ),
            isset( $args['attributes'] ) ? wc_implode_html_attributes( $args['attributes'] ) : '',
            esc_html( $product->add_to_cart_text() )
        );
    }
}
// Loop Product title
if ( ! function_exists( 'woocommerce_template_loop_product_title' ) ) {

    /**
     * Show the product title in the product loop. By default this is an H2.
     */
    function woocommerce_template_loop_product_title() {
        echo '<h2 class="' . esc_attr( apply_filters( 'woocommerce_product_loop_title_classes', 'woocommerce-loop-product__title' ) ) . '"><a href="'.get_the_permalink().'">'. get_the_title() . '</a></h2>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
    }
}



// Pagination
add_filter('woocommerce_pagination_args', 'fortis_woocommerce_pagination_args');
if(!function_exists('fortis_woocommerce_pagination_args')){
    function fortis_woocommerce_pagination_args($default){
        $default = array_merge($default, [
            'prev_text' => '<i class="cmsi-arrow-left text-10 rtl-flip"></i>',
            'next_text' => '<i class="cmsi-arrow-right text-10 rtl-flip"></i>',
            'type'      => 'plain',
        ]);
        return $default;
    }
}

/**
 * Single Product
 * 
 * **/
// Change sale position
remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash');
add_action('woocommerce_product_thumbnails', 'woocommerce_show_product_sale_flash', 99);

// Review count & link 
if ( ! function_exists( 'woocommerce_template_single_rating' ) ) {
    // change position
    //remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
    //add_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 11);
    /**
     * Output the product rating.
     */
    function woocommerce_template_single_rating() {
        if ( !post_type_supports( 'product', 'comments' ) || ! wc_review_ratings_enabled() ) {
            return;
        }
        global $product;
        $rating_count = $product->get_rating_count();
        $review_count = $product->get_review_count();
        $average      = $product->get_average_rating();

        $review_url =  get_the_permalink($product->get_id()).'#reviews';

        //if ( $rating_count > 0 ) : 
            ?>
            <div class="woocommerce-product-rating">
                <?php echo wc_get_rating_html( $average, $rating_count ); // WPCS: XSS ok. ?>
                <?php if ( comments_open() ) : ?>
                    <?php //phpcs:disable ?>
                    <a href="<?php echo esc_attr($review_url); ?>" class="woocommerce-review-link" rel="nofollow"><?php printf( _n( '%s review', '%s reviews', $review_count, 'fortis' ), '<span class="count">' . esc_html( $review_count ) . '</span>' ); ?> / <?php esc_html_e('Add review','fortis'); ?></a>
                    <?php // phpcs:enable ?>
                <?php endif ?>
            </div>
        <?php 
        //endif;
    }
}
// Share
add_action('woocommerce_share', 'fortis_social_share_product');
function fortis_social_share_product(){ 
    $show_show_share = fortis_get_opt('show_show_share', 'off');
    if($show_show_share === 'off') return;
    ?>
    <div class="cms-product-share">
        <a class="fb-social hover-effect" title="<?php echo esc_attr__('Facebook', 'fortis'); ?>" target="_blank"
           href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"><i class="cmsi-facebook-f"></i></a>
        <a class="tw-social hover-effect" title="<?php echo esc_attr__('Twitter', 'fortis'); ?>" target="_blank"
           href="https://twitter.com/home?status=<?php the_permalink(); ?>"><i class="cmsi-twitter"></i></a>
        <a class="" title="<?php echo esc_attr__('Share this post to Instagram','fortis');?>" target="_blank" href="https://instagram.com/"><i class="cmsi-instagram"></i></a>

        <a class="g-social hover-effect d-none" title="<?php echo esc_attr__('Google Plus', 'fortis'); ?>" target="_blank"
           href="https://plus.google.com/share?url=<?php the_permalink(); ?>"><i class="cmsi-google-plus"></i></a>
        <a class="pin-social hover-effect d-none" title="<?php echo esc_attr__('Pinterest', 'fortis'); ?>" target="_blank"
        href="https://pinterest.com/pin/create/button/?url=<?php echo esc_url(the_post_thumbnail_url('full')); ?>&media=&description=<?php the_title(); ?>"><i class="cmsi-pinterest"></i></a>
    </div>
    <?php
}
// Tabs
add_filter('woocommerce_product_description_heading','fortis_product_tab_heading');
add_filter('woocommerce_product_additional_information_heading','fortis_product_tab_heading');
if(!function_exists('fortis_product_tab_heading')){
    function fortis_product_tab_heading(){
        return false;
    }
}
// Product Nav
function fortis_product_nav(){
    global $post;
    $previous = (is_attachment()) ? get_post($post->post_parent) : get_adjacent_post(false, '', true);
    $next = get_adjacent_post(false, '', false);

    if (!$next && !$previous) {
        return;
    }
    ?>
    <?php
    $next_post = get_next_post();
    $previous_post = get_previous_post();
    if (!empty($next_post) || !empty($previous_post)) { ?>
        <div class="product-previous-next">
            <?php if (is_a($previous_post, 'WP_Post') && get_the_title($previous_post->ID) != '') { ?>
                <a class="nav-link-prev" href="<?php echo esc_url(get_permalink($previous_post->ID)); ?>"><i
                            class="cmsi-long-arrow-left"></i></a>
            <?php } ?>
            <?php if (is_a($next_post, 'WP_Post') && get_the_title($next_post->ID) != '') { ?>
                <a class="nav-link-next" href="<?php echo esc_url(get_permalink($next_post->ID)); ?>"><i
                            class="cmsi-long-arrow-right"></i></a>
            <?php } ?>
        </div>
    <?php }
}
// Product Comment
/**
 * Review callback function 
 * make it callback same as default blog review
*/
if(!function_exists('fortis_woocommerce_product_review_list_args')){
    add_filter('woocommerce_product_review_list_args', 'fortis_woocommerce_product_review_list_args');
    function fortis_woocommerce_product_review_list_args($args){
        $args['style']      = 'div';
        $args['short_ping'] = 'true';
        $args['callback']   = 'fortis_comment_list';
        return $args;
    }
}

remove_action('woocommerce_review_meta','woocommerce_review_display_meta', 10);
remove_action('woocommerce_review_comment_text','woocommerce_review_display_comment_text', 10);
/**
 * Comment form Args
*/
if(!function_exists('fortis_woocommerce_product_review_comment_form_args')){
    add_filter('woocommerce_product_review_comment_form_args', 'fortis_woocommerce_product_review_comment_form_args');
    function fortis_woocommerce_product_review_comment_form_args($comment_form){
        $comment_form = fortis_comment_form_args();
        return $comment_form;
    }
}
/**
 * Upsell, Cross Sell, Related
 * */
add_filter('woocommerce_upsells_columns', function(){ return 4;});
add_filter('woocommerce_upsells_total', function(){ return 4;});
// Cross sell
add_filter('woocommerce_cross_sells_columns' , function(){ return 4;});
add_filter('woocommerce_cross_sells_total' , function(){ return 4;});

/**
 * Quantity Form
 * 
**/
add_action( 'woocommerce_after_quantity_input_field', 'fortis_woocommerce_after_quantity_input_field' );
if(!function_exists('fortis_woocommerce_after_quantity_input_field')){
    function fortis_woocommerce_after_quantity_input_field(){
?>
    <span class="cms-qty-act cms-qty-up"></span>
    <span class="cms-qty-act cms-qty-down"></span>
<?php
    }
}