<?php
$source = $widget->get_setting('source', '');
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 4);
$post_ids = $widget->get_setting('post_ids', '');
extract(pxl_get_posts_of_grid('post', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));
if (is_array($posts)): ?>
    <div class="pxl-blog-list1">
        <div class="pxl-blog-inner">
            <?php
                foreach ($posts as $key => $post): 
                ?>
                <div class="pxl-grid-item <?php echo esc_attr( $settings['pxl_animate'] ); ?>">
                    <h3 class="pxl-item--title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a></h3>
                    <div class="pxl-item--date">
                        <i class="caseicon caseicon-calendar"></i>
                        <?php $date_formart = get_option('date_format'); echo get_the_date($date_formart, $post->ID); ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
<?php endif; ?>