<?php
$widget->add_render_attribute( 'counter', [
    'class' => 'pxl-counter--value '.$settings['effect'].'',
    'data-duration' => $settings['duration'],
    'data-startnumber' => $settings['starting_number'],
    'data-endnumber' => $settings['ending_number'],
    'data-to-value' => $settings['ending_number'],
    'data-delimiter' => $settings['thousand_separator_char'],
] ); ?>
<div class="pxl-counter pxl-counter5 <?php echo esc_attr( $settings['pxl_animate'] ); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-counter-inner pxl-flex">
        <div class="pxl-counter--box">
            <div class="pxl-counter--number <?php echo esc_attr($settings['style_number']) ;?>">
                <span class="pxl-counter--prefix el-empty"><?php echo pxl_print_html($settings['prefix']); ?></span>
                <span <?php pxl_print_html($widget->get_render_attribute_string( 'counter' )); ?>><?php echo esc_html($settings['starting_number']); ?></span>
                <?php if(!empty($settings['suffix'])) : ?>
                    <span class="pxl-counter--suffix"><?php echo pxl_print_html($settings['suffix']); ?></span>
                <?php endif; ?>
            </div>
            <?php if( $settings['show_star'] == 'true' ) : ?>
                <div class="pxl-star-wrap <?php echo esc_attr($settings['star_stype_color']);?>">
                    <span class="pxl-item--star pxl-item--<?php echo esc_attr($settings['star']); ?>">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </span>
                </div>
            <?php endif; ?>
        </div>
        <div class="pxl-counter-meta">
            <?php if(!empty($settings['title'])) : ?>
                <div class="pxl-counter--title"><?php echo pxl_print_html($settings['title']); ?></div>
            <?php endif; ?>
            <?php if(!empty($settings['title_suffix'])) : ?>
                <span class="pxl-suffix-title"><?php echo pxl_print_html($settings['title_suffix']); ?></span>
            <?php endif; ?>
        </div>
    </div>
</div>