<?php 
    $img_size = isset($settings['img_size']) ? $settings['img_size'] : '';
    $image_size = !empty($img_size) ? $img_size : '800x625';
?>
<div class="pxl-history pxl-history1" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-list-items">
        <?php if(isset($settings['history_list']) && !empty($settings['history_list']) && count($settings['history_list'])): ?>
            <?php foreach ($settings['history_list'] as $key => $value):
                $feature = isset($value['feature']) ? $value['feature'] : ''; ?>
                <div class="pxl--item elementor-repeater-item-<?php echo esc_attr($value['_id']); ?> <?php echo esc_attr($settings['pxl_animate']); ?>">
                    <div class="pxl-number">
                        <?php echo pxl_print_html($value['history_number'])?>
                    </div>
                    <div class="pxl-content">
                         <?php if(!empty($feature['id'])) { 
                            $img_feature = pxl_get_image_by_size( array(
                                'attach_id'  => $feature['id'],
                                'thumb_size' => $image_size,
                                'class' => 'no-lazyload',
                            ));
                            $thumbnail_feature = $img_feature['thumbnail'];
                            ?>
                            <div class="pxl-item--feature">
                                <?php echo wp_kses_post($thumbnail_feature); ?>
                            </div>
                        <?php } ?>
                        <div class="pxl-meta">
                            <h5 class="pxl-item--title">
                                <?php echo pxl_print_html($value['history_title'])?>
                            </h5>
                            <div class="pxl-item--description">
                                <?php echo pxl_print_html($value['history_content'])?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>