<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');

$col_xl = 12 / intval($col_xl);
$col_lg = 12 / intval($col_lg);
$col_md = 12 / intval($col_md);
$col_sm = 12 / intval($col_sm);
$col_xs = 12 / intval($col_xs);

$grid_sizer = "col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
$item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
$image_size = !empty($settings['img_size']) ? $settings['img_size'] : 'full';
?>
<?php if(isset($settings['meta']) && !empty($settings['meta']) && count($settings['meta'])):
    $is_new = \Elementor\Icons_Manager::is_migration_allowed(); ?>
    <div class="pxl-grid pxl-meta-grid pxl-meta-grid1">
        <div class="pxl-grid-inner pxl-grid-masonry row" data-gutter="15">
            <?php foreach ($settings['meta'] as $key => $value):
                $icon_key = $widget->get_repeater_setting_key( 'pxl_icon', 'icons', $key );
                $widget->add_render_attribute( $icon_key, [
                    'class' => $value['pxl_icon'],
                    'aria-hidden' => 'true',
                ] );
    			$title = isset($value['title']) ? $value['title'] : '';
                $desc = isset($value['desc']) ? $value['desc'] : '';
                ?>
                <div class="<?php echo esc_attr($item_class); ?>">
                    <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate']); ?>">
                        <?php if ( ! empty( $value['pxl_icon'] ) ) : ?>
                            <div class="pxl-item--icon">
                                <?php if ( $is_new ):
                                    \Elementor\Icons_Manager::render_icon( $value['pxl_icon'], [ 'aria-hidden' => 'true' ] );
                                elseif(!empty($value['pxl_icon'])): ?>
                                    <i class="<?php echo esc_attr( $value['pxl_icon'] ); ?>" aria-hidden="true"></i>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                        <div class="pxl-item--holder">
                            <h5 class="pxl-item--title">
                                <?php echo pxl_print_html($title); ?>
                            </h5>
                            <div class="pxl-item--desc"><?php echo pxl_print_html($desc); ?></div>
                        </div>
                   </div>
                </div>
            <?php endforeach; ?>
            <div class="grid-sizer <?php echo esc_attr($grid_sizer); ?>"></div>
        </div>
    </div>
<?php endif; ?>
