<?php
$source = $widget->get_setting('source', '');
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 4);
$post_ids = $widget->get_setting('post_ids', '');
$images_size = !empty($img_size) ? $img_size : '700x700';
extract(pxl_get_posts_of_grid('portfolio', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$active_index   = $widget->get_setting('item_active', '2');
$show_video = $widget->get_setting('show_video');
$show_button = $widget->get_setting('show_button');
$show_category  = $widget->get_setting('show_category');
if (is_array($posts)): ?>
    <div class="pxl-portfolio-flex">
        <div class="pxl-portfolio-inner">
            <?php
                foreach ($posts as $key => $post): 
                $img_id = get_post_thumbnail_id($post->ID);
                if($img_id) {
                    $img = pxl_get_image_by_size( array(
                        'attach_id'  => $img_id,
                        'thumb_size' => $images_size,
                        'class' => 'no-lazyload',
                    ));
                    $thumbnail = $img['thumbnail'];
                    $thumbnail_url    = $img['url'];
                } else {
                    $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
                }
                $class_actvie = ($key + 1) == $active_index ? 'active':'';
                $featured_video = get_post_meta($post->ID, 'portfolio_video_link', true);
                $portfolio_external_link = get_post_meta($post->ID, 'portfolio_external_link', true);
                ?>
                <div class="pxl-grid-item <?php echo esc_attr( $settings['style_box'].' '.$class_actvie ) ?> wow skewIn">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)){  ?>
                        <div class="bg-image" style="background-image: url(<?php echo wp_kses_post($thumbnail_url); ?>);"></div>
                        <div class="pxl-item--meta">
                            <?php if($show_category == 'true'): ?>
                                <div class="pxl-item--category">
                                    <?php the_terms( $post->ID, 'portfolio-category', '', ' ' ); ?>
                                </div>
                            <?php endif; ?>
                            <h3 class="pxl-item--title"><a href="<?php if(!empty($portfolio_external_link)) { echo esc_url($portfolio_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a></h3>
                            <div class="px-meta-links">
                                <?php if($show_video == 'true' && !empty($featured_video)): ?>
                                    <a class="pxl-post--video pxl-fl-middle pxl-action-popup" href="<?php echo esc_url($featured_video); ?>">
                                        <i class="caseicon-right-arrow"></i>
                                    </a>
                                <?php endif; ?>
                                <?php if($show_button == 'true') : ?>
                                    <a class="pxl-post--readmore pxl-fl-middle" href="<?php if(!empty($portfolio_external_link)) { echo esc_url($portfolio_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                        <i class="caseicon-link"></i>
                                    </a>
                                <?php endif; ?>
                            </div> 
                        </div>
                    <?php } ?>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
<?php endif; ?>