<?php
extract($settings);
$html_id = pxl_get_element_id($settings);
$tax = ['portfolio-category'];
$select_post_by = $widget->get_setting('select_post_by', '');
$source = $post_ids = [];
if($select_post_by === 'post_selected'){
    $post_ids = $widget->get_setting('source_'.$settings['post_type'].'_post_ids', '');
}else{
    $source  = $widget->get_setting('source_'.$settings['post_type'], '');
}
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$settings['layout']    = $settings['layout_'.$settings['post_type']];
extract(pxl_get_posts_of_grid('portfolio', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
    'tax'=> $tax,
]));

$pxl_animate = $widget->get_setting('pxl_animate', '');
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = (int)$widget->get_setting('col_md', '');
if($col_md == 'custom') {
    $col_md = $widget->get_setting('col_md_custom', '');
}
$col_lg = (int)$widget->get_setting('col_lg', '');
if($col_lg == 'custom') {
    $col_lg = $widget->get_setting('col_lg_custom', '');
}
$col_xl = (int)$widget->get_setting('col_xl', '');
if($col_xl == 'custom') {
    $col_xl = $widget->get_setting('col_xl_custom', '');
}
$col_xxl = (int)$widget->get_setting('col_xxl', '');
if($col_xxl == 'custom') {
    $col_xxl = $widget->get_setting('col_xxl_custom', '');
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows', false);
$arrows_position = $widget->get_setting('arrows_position', 'arrows-bottom');
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', 5000);
$infinite = $widget->get_setting('infinite', false);
$speed = $widget->get_setting('speed', 500);
$drap = $widget->get_setting('drap', false);
$center = $widget->get_setting('center', false);

$img_size = $widget->get_setting('img_size');
$show_category = $widget->get_setting('show_category');
$show_video = $widget->get_setting('show_video');
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_percolumnfill'           => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => $col_xl, 
    'slides_to_show_xxl'            => $col_xxl, 
    'slides_to_show_lg'             => $col_lg, 
    'slides_to_show_md'             => $col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,  
    'slides_gutter'                 => 30, 
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed,
    'center'                        => (bool)$center,
];

$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]); ?>

<?php if (is_array($posts)): ?>
    <div class="pxl-swiper-slider pxl-portfolio-carousel pxl-portfolio-carousel1" <?php if($drap !== false): ?>data-cursor-drap="<?php echo esc_attr__('DRAG', 'industio'); ?>"<?php endif; ?>>
        <div class="swiper-filter">
            <div class="container-custom">
                <?php if( !empty($settings['el_sub_title'] ) || !empty($settings['el_title']) ) { ?>
                    <div class="pxl-wrapper-heading">
                        <?php if(!empty($settings['el_sub_title'])) : ?>
                            <div class="el--subtitle">
                                <?php if (!empty($settings['pxl_icon_subtitle']['value']) ) : ?>
                                    <span class="pxl-item--icon">
                                        <?php \Elementor\Icons_Manager::render_icon( $settings['pxl_icon_subtitle'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
                                    </span>
                                <?php endif; ?>
                                <span><?php echo pxl_print_html($settings['el_sub_title']); ?></span>
                            </div>
                        <?php endif; ?>
                        <<?php echo esc_attr($settings['title_tag']); ?> class="el--title">
                            <span><?php echo pxl_print_html($settings['el_title']); ?></span>
                        </<?php echo esc_attr($settings['title_tag']); ?>>
                    </div>
                <?php } ?>
                <?php if ($settings['filter']=='true') { ?>
                    <div class="pxl-grid-filter">
                        <div class="pxl--filter-inner">
                            <?php if(!empty($filter_default_title)): ?>
                                <span class="filter-item active" data-filter-target="all">
                                    <span class="cat-name"><?php echo esc_html($filter_default_title); ?></span>
                                </span>
                            <?php endif; ?>
                            <?php foreach ( $categories as $category ):
                                $category_arr = explode('|', $category);
                                $term = get_term_by('slug',$category_arr[0], $category_arr[1]);
                                ?>
                                <span class="filter-item" data-filter-target="<?php echo esc_attr($term->slug); ?>">
                                    <span class="cat-name"><?php echo esc_html($term->name); ?></span>
                                </span>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php  } ?>
            </div>
        </div>
        <div class="pxl-carousel-inner <?php echo esc_attr($arrows_position); ?>">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php
                        $image_size = !empty($img_size) ? $img_size : '550x700';
                        foreach ($posts as $post): 
                        $img_id = get_post_thumbnail_id($post->ID);
                        $img          = pxl_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => $image_size
                        ) );
						$featured_video = get_post_meta($post->ID, 'portfolio_video_link', true);
                        $thumbnail    = $img['thumbnail'];
                        $filter_class = '';
                        if ($select_post_by === 'term_selected' )
                            $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
                        ?>
                        <div class="pxl-swiper-slide" data-filter="<?php echo esc_attr($filter_class); ?>">
                            <div class="pxl-post--inner <?php echo esc_attr($settings['style_box2'].' '.$pxl_animate); ?>" data-wow-duration="1.2s">
                                <div class="pxl-post--featured hover-imge-effect3">
                                    <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                                </div>
                                <div class="pxl-post--holder">
                                    <?php if($show_category == 'true'): ?>
                                        <div class="pxl-post--category link-none">
                                            <?php the_terms( $post->ID, 'portfolio-category', '', ' ' ); ?>
                                        </div>
                                    <?php endif; ?>
                                    <h5 class="pxl-post--title">
                                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                            <?php echo esc_html(get_the_title($post->ID)); ?>
                                        </a>
                                    </h5>
                                    <div class="px-meta-links">
                                        <?php if($show_video == 'true' && !empty($featured_video)): ?>
                                            <a class="pxl-post--video pxl-fl-middle pxl-action-popup" href="<?php echo esc_url($featured_video); ?>">
                                                <i class="caseicon-right-arrow"></i>
                                            </a>
                                        <?php endif; ?>
                                        <a class="pxl-post--readmore pxl-fl-middle" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                            <i class="caseicon-link"></i>
                                        </a>
                                    </div>                         
                                </div>
                            </div>
                        </div>    
                    <?php endforeach; ?>
                </div> 
            </div>
            
            <?php if($pagination !== false): ?>
                <div class="pxl-swiper-dots-wrap">
                    <div class="pxl-swiper-dots style-1"></div>
                </div>
            <?php endif; ?>

            <?php if($arrows !== false): ?>
                <div class="pxl-swiper-arrow-wrap style-1">
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-prev">
                         <svg version="1.1" class="rtl-icon" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><path d="M492,236H68.442l70.164-69.824c7.829-7.792,7.859-20.455,0.067-28.284c-7.792-7.83-20.456-7.859-28.285-0.068 l-104.504,104c-0.007,0.006-0.012,0.013-0.018,0.019c-7.809,7.792-7.834,20.496-0.002,28.314c0.007,0.006,0.012,0.013,0.018,0.019 l104.504,104c7.828,7.79,20.492,7.763,28.285-0.068c7.792-7.829,7.762-20.492-0.067-28.284L68.442,276H492 c11.046,0,20-8.954,20-20C512,244.954,503.046,236,492,236z"/></svg>
                    </div>
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-next">
                        <svg version="1.1" class="rtl-icon" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><path d="M506.134,241.843c-0.006-0.006-0.011-0.013-0.018-0.019l-104.504-104c-7.829-7.791-20.492-7.762-28.285,0.068 c-7.792,7.829-7.762,20.492,0.067,28.284L443.558,236H20c-11.046,0-20,8.954-20,20c0,11.046,8.954,20,20,20h423.557 l-70.162,69.824c-7.829,7.792-7.859,20.455-0.067,28.284c7.793,7.831,20.457,7.858,28.285,0.068l104.504-104 c0.006-0.006,0.011-0.013,0.018-0.019C513.968,262.339,513.943,249.635,506.134,241.843z"/></svg>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>