<?php
$html_id = pxl_get_element_id($settings);
$select_post_by = $widget->get_setting('select_post_by', '');
$source = $post_ids = [];
if($select_post_by === 'post_selected'){
    $post_ids = $widget->get_setting('source_'.$settings['post_type'].'_post_ids', '');
}else{
    $source  = $widget->get_setting('source_'.$settings['post_type'], '');
}
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$settings['layout']    = $settings['layout_'.$settings['post_type']];
extract(pxl_get_posts_of_grid('service', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$pxl_animate = $widget->get_setting('pxl_animate', '');
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = (int)$widget->get_setting('col_md', '');
if($col_md == 'custom') {
    $col_md = $widget->get_setting('col_md_custom', '');
}
$col_lg = (int)$widget->get_setting('col_lg', '');
if($col_lg == 'custom') {
    $col_lg = $widget->get_setting('col_lg_custom', '');
}
$col_xl = (int)$widget->get_setting('col_xl', '');
if($col_xl == 'custom') {
    $col_xl = $widget->get_setting('col_xl_custom', '');
}
$col_xxl = (int)$widget->get_setting('col_xxl', '');
if($col_xxl == 'custom') {
    $col_xxl = $widget->get_setting('col_xxl_custom', '');
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows_position = $widget->get_setting('arrows_position', 'arrows-bottom');
$show_button = $widget->get_setting('show_button');
$show_excerpt = $widget->get_setting('show_excerpt');
$num_words = $widget->get_setting('num_words');

$arrows = $widget->get_setting('arrows', false);
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type','bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', 5000);
$infinite = $widget->get_setting('infinite', false);
$speed = $widget->get_setting('speed', 500);
$drap = $widget->get_setting('drap', false);

$img_size = $widget->get_setting('img_size');
$show_button = $widget->get_setting('show_button');

$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_percolumnfill'           => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => $col_xl, 
    'slides_to_show_xxl'            => $col_xxl, 
    'slides_to_show_lg'             => $col_lg, 
    'slides_to_show_md'             => $col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,  
    'slides_gutter'                 => 30, 
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed,
];

$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]); ?>

<?php if (is_array($posts)): ?>
    <div class="pxl-swiper-slider pxl-service-carousel pxl-service-carousel2" <?php if($drap !== false): ?>data-cursor-drap="<?php echo esc_attr__('DRAG', 'industio'); ?>"<?php endif; ?>>
        <div class="pxl-carousel-inner <?php echo esc_attr($arrows_position); ?>">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php
                        $image_size = !empty($img_size) ? $img_size : '600x472';
                        foreach ($posts as $key => $post):
                        $service_external_link = get_post_meta($post->ID, 'service_external_link', true);
                        $service_icon_type = get_post_meta($post->ID, 'service_icon_type', true);
                        $service_icon_font = get_post_meta($post->ID, 'service_icon_font', true);
                        $service_icon_img = get_post_meta($post->ID, 'service_icon_img', true);
                        ?>
                        <div class="pxl-swiper-slide">
                            <div class="pxl-post--inner <?php echo esc_attr($settings['style_service'].' '.$pxl_animate); ?>">
                                <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):
                                    $img_id = get_post_thumbnail_id($post->ID);
                                    $img          = pxl_get_image_by_size( array(
                                        'attach_id'  => $img_id,
                                        'thumb_size' => $image_size
                                    ) );
                                    $thumbnail    = $img['thumbnail'];
                                    ?>
                                    <div class="pxl-post--featured">
                                        <div class="inner-post--featured">
                                            <?php echo wp_kses_post($thumbnail); ?>    
                                        </div>
                                        <?php if($service_icon_type == 'icon' && !empty($service_icon_font)) : ?>
                                            <div class="pxl-post--icon">
                                                <div class="inner-icon pxl-fl-middle">
                                                    <i class="<?php echo esc_attr($service_icon_font); ?>"></i>
                                                </div>
                                                <?php if ( $settings['style_service'] == 'item-style1' ) { ?>
                                                    <span class="line-item line-1"></span>
                                                    <span class="line-item line-2"></span>
                                                    <span class="line-item line-3"></span>
                                                <?php } ?>
                                            </div>
                                        <?php endif; ?>
                                        <?php if($service_icon_type == 'image' && !empty($service_icon_img)) : 
                                            $icon_img = pxl_get_image_by_size( array(
                                                'attach_id'  => $service_icon_img['id'],
                                                'thumb_size' => 'full',
                                            ));
                                            $icon_thumbnail = $icon_img['thumbnail'];
                                            ?>
                                            <div class="pxl-post--icon">
                                                <div class="inner-icon pxl-fl-middle">
                                                    <?php echo wp_kses_post($icon_thumbnail); ?>
                                                </div>
                                                <?php if ( $settings['style_service'] == 'item-style1' ) { ?>
                                                    <span class="line-item line-1"></span>
                                                    <span class="line-item line-2"></span>
                                                    <span class="line-item line-3"></span>
                                                <?php } ?>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <a class="pxl-post--link" href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"></a>
                                    </div>
                                <?php endif; ?>
                                <div class="pxl-post--contents">
                                    <div class="inner--holder">
                                        <?php if ( $settings['style_service'] == 'item-style1' ) { ?>
                                            <div class="pxl-post--category"><?php the_terms( $post->ID, 'service-category', '', ' ' ); ?></div>
                                        <?php } ?>
                                        <?php if ( $settings['style_service'] == 'item-style2' ) { ?>
                                            <?php if ( $key <= 9 ) { ?>
                                                <span class="item-number item-number1">0<?php echo esc_html($key + 1); ?></span>    
                                            <?php } else { ?>
                                                <span class="item-number item-number1"><?php echo esc_html($key) ; ?></span>    
                                            <?php } ?>
                                        <?php } ?>
                                        <h3 class="pxl-post--title">
                                            <a href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a>
                                        </h3>
                                    </div>
                                </div>
                                <div class="pxl-post--contents-holder">
                                    <div class="inner--holder">
                                        <?php if ( $settings['style_service'] == 'item-style2' ) { ?>
                                            <?php if ( $key <= 9 ) { ?>
                                                <span class="item-number item-number1">0<?php echo esc_html($key + 1); ?></span>    
                                            <?php } else { ?>
                                                <span class="item-number item-number1"><?php echo esc_html($key) ; ?></span>    
                                            <?php } ?>
                                        <?php } ?>
                                        <?php if ( $settings['style_service'] == 'item-style1' ) { ?>
                                            <div class="pxl-post--category"><?php the_terms( $post->ID, 'service-category', '', ' ' ); ?></div>
                                        <?php } ?>
                                        <h3 class="pxl-post--title">
                                            <a href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a>
                                        </h3>
                                        <?php if($show_excerpt == 'true'): ?>
                                            <div class="pxl-post--content">
                                                <?php echo wp_trim_words( $post->post_excerpt, $num_words, $more = null ); ?>
                                            </div>
                                        <?php endif; ?>
                                        <?php if($show_button == 'true') : ?>
                                            <a class="btn" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                                <span class="btn--text">
                                                    <?php if(!empty($button_text)) {
                                                        echo esc_attr($button_text);
                                                    } else {
                                                        echo esc_html__('Read More', 'industio');
                                                    } ?>
                                                </span>
                                                <?php if ( $settings['style_service'] == 'item-style1' ) { ?>
                                                    <span class="btn--icon">
                                                        <i class="flaticon flaticon-up-right-arrow-1"></i>    
                                                    </span>
                                                <?php } ?>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>    
                    <?php endforeach; ?>
                </div> 
            </div>
            
            <?php if($pagination !== false): ?>
                <div class="pxl-swiper-dots-wrap">
                    <div class="pxl-swiper-dots style-2"></div>
                </div>
            <?php endif; ?>

            <?php if($arrows !== false): ?>
                <div class="pxl-swiper-arrow-wrap style-1">
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-prev">
                         <svg version="1.1" class="rtl-icon" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><path d="M492,236H68.442l70.164-69.824c7.829-7.792,7.859-20.455,0.067-28.284c-7.792-7.83-20.456-7.859-28.285-0.068 l-104.504,104c-0.007,0.006-0.012,0.013-0.018,0.019c-7.809,7.792-7.834,20.496-0.002,28.314c0.007,0.006,0.012,0.013,0.018,0.019 l104.504,104c7.828,7.79,20.492,7.763,28.285-0.068c7.792-7.829,7.762-20.492-0.067-28.284L68.442,276H492 c11.046,0,20-8.954,20-20C512,244.954,503.046,236,492,236z"/></svg>
                    </div>
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-next">
                        <svg version="1.1" class="rtl-icon" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><path d="M506.134,241.843c-0.006-0.006-0.011-0.013-0.018-0.019l-104.504-104c-7.829-7.791-20.492-7.762-28.285,0.068 c-7.792,7.829-7.762,20.492,0.067,28.284L443.558,236H20c-11.046,0-20,8.954-20,20c0,11.046,8.954,20,20,20h423.557 l-70.162,69.824c-7.829,7.792-7.859,20.455-0.067,28.284c7.793,7.831,20.457,7.858,28.285,0.068l104.504-104 c0.006-0.006,0.011-0.013,0.018-0.019C513.968,262.339,513.943,249.635,506.134,241.843z"/></svg>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>