<div class="pxl-pricing pxl-pricing1">
    <div class="pxl-pricing--title pxl-empty"><?php echo pxl_print_html($settings['title']); ?></div>
    <div class="pxl-pricing--excerpt pxl-empty"><?php echo pxl_print_html($settings['excerpt']); ?></div>
    <?php if(!empty($settings['feature_image']['id'])) { 
        $image_size = !empty($settings['img_size']) ? $settings['img_size'] : '800x320';
        $img = pxl_get_image_by_size( array(
            'attach_id'  => $settings['feature_image']['id'],
            'thumb_size' => $image_size,
            'class' => 'no-lazyload'
        ));
        $thumbnail = $img['thumbnail'];
        ?>
        <div class="pxl-prc-image">
            <?php echo pxl_print_html($thumbnail); ?>
        </div>
    <?php } ?>
    <div class="pxl-pricing--price">
        <span class="pxl-pricing--currency"><?php echo pxl_print_html($settings['currency']); ?></span>
        <span class="pxl-price"><?php echo pxl_print_html($settings['price']); ?></span>
        <span class="pxl-suffix"><?php echo pxl_print_html($settings['price_suffix']); ?></span>
    </div>
    <?php if(isset($settings['feature']) && !empty($settings['feature']) && count($settings['feature'])): ?>
        <ul class="pxl-pricing--feature">
            <?php
                foreach ($settings['feature'] as $key => $link):
                    $feature_text = $widget->parse_text_editor( $link['feature_text'] );
                    $feature_active = $widget->parse_text_editor( $link['feature_active'] );  ?>
                    <li>
                        <svg width="14" height="16" viewBox="0 0 14 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M5.4068 0.66773C6.40975 0.166258 7.59025 0.166258 8.59322 0.66773L12.4223 2.58232C13.1211 2.93169 13.5625 3.64585 13.5625 4.42708V10.0873C13.5625 11.3156 12.9297 12.4573 11.8881 13.1083L8.09312 15.4801C7.42435 15.8981 6.57565 15.8981 5.90687 15.4801L2.11187 13.1083C1.07027 12.4573 0.4375 11.3156 0.4375 10.0873V4.42708C0.4375 3.64585 0.878883 2.93169 1.57762 2.58232L5.4068 0.66773ZM9.64772 6.89775C9.8674 6.67807 9.8674 6.32194 9.64772 6.10228C9.42805 5.88261 9.07195 5.88261 8.85227 6.10228L6.25 8.7045L5.14775 7.6023C4.92808 7.38262 4.57192 7.38262 4.35225 7.6023C4.13258 7.82197 4.13258 8.17807 4.35225 8.39775L5.85227 9.89775C5.95772 10.0033 6.10082 10.0625 6.25 10.0625C6.39917 10.0625 6.54227 10.0033 6.64772 9.89775L9.64772 6.89775Z" fill="#FA4318"/>
                        </svg>
                        <?php if($feature_active == 'no') { echo '<del>'; } ?>
                        <?php echo pxl_print_html($feature_text); ?>
                        <?php if($feature_active == 'no') { echo '</del>'; } ?>
                    </li>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>
    <?php if ( ! empty( $settings['btn_text'] ) ) {
        $widget->add_render_attribute( 'btn_link', 'href', $settings['btn_link']['url'] );

        if ( $settings['btn_link']['is_external'] ) {
            $widget->add_render_attribute( 'btn_link', 'target', '_blank' );
        }

        if ( $settings['btn_link']['nofollow'] ) {
            $widget->add_render_attribute( 'btn_link', 'rel', 'nofollow' );
        } ?>
        <div class="pxl-pricing--button">
            <a class="btn" <?php pxl_print_html($widget->get_render_attribute_string( 'btn_link' )); ?>><span><?php echo esc_html($settings['btn_text']); ?></span><i class="flaticon-right-arrow-1 pxl-ml-18"></i></a>
        </div>
    <?php } ?>
</div>