<?php 
$default_settings = [
    'title' => '',
    'img_size' => '',
    'image_link' => '',
    'notification' => '',
    'notification_label' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
$size = 'full';
if(!empty($img_size)) {
    $size = $img_size;
} else {
    $size = 'full';
}
if ( ! empty( $image_link['url'] ) ) {
    $widget->add_render_attribute( 'image_link', 'href', $image_link['url'] );

    if ( $image_link['is_external'] ) {
        $widget->add_render_attribute( 'image_link', 'target', '_blank' );
    }

    if ( $image_link['nofollow'] ) {
        $widget->add_render_attribute( 'image_link', 'rel', 'nofollow' );
    }
}

if ( ! empty( $settings['link']['url'] ) ) {
    $widget->add_render_attribute( 'link', 'href', $settings['link']['url'] );
    $icon_tag = 'a';

    if ( $settings['link']['is_external'] ) {
        $widget->add_render_attribute( 'link', 'target', '_blank' );
    }

    if ( $settings['link']['nofollow'] ) {
        $widget->add_render_attribute( 'link', 'rel', 'nofollow' );
    }
}
$link_attributes = $widget->get_render_attribute_string( 'link' );

if ( ! empty( $settings['link2']['url'] ) ) {
    $widget->add_render_attribute( 'link2', 'href', $settings['link2']['url'] );
    $icon_tag = 'a';

    if ( $settings['link2']['is_external'] ) {
        $widget->add_render_attribute( 'link2', 'target', '_blank' );
    }

    if ( $settings['link2']['nofollow'] ) {
        $widget->add_render_attribute( 'link2', 'rel', 'nofollow' );
    }
}
$link_attributes2 = $widget->get_render_attribute_string( 'link2' );
?>
<div class="pxl-showcase pxl-showcase3 <?php echo esc_attr( $settings['item_display'].' '.$settings['pxl_animate'] ); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-item--inner">
        <div class="pxl-image-bg"></div>
        <div class="item-feature">
            <?php if(!empty($settings['image']['id'])) :
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $settings['image']['id'],
                    'thumb_size' => 'full',
                ));
                $thumbnail = $img['thumbnail']; ?>
                <?php echo pxl_print_html($thumbnail); ?>
            <?php endif; ?>
            <div class="pxl-item-links">
                <?php if( ! empty($settings['btn_text1']) || !empty( $settings['link1']['url'] ) ) { ?>
                    <a class="btn btn-primary" <?php pxl_print_html($widget->get_render_attribute_string( 'link' )); ?>><?php echo pxl_print_html($settings['btn_text1']); ?> <i class="flaticon flaticon-up-right-arrow-1"></i></a>
                <?php } ?>
                <?php if( ! empty($settings['btn_text2']) || !empty( $settings['link2']['url'] ) ) { ?>
                    <a class="btn btn-primary style-lv2" <?php pxl_print_html($widget->get_render_attribute_string( 'link2' )); ?>><?php echo pxl_print_html($settings['btn_text2']); ?><i class="flaticon flaticon-up-right-arrow-1"></i></a>
                <?php } ?>
            </div>
        </div> 
        <div class="pxl-item--meta">
            <?php if ( ! empty( $settings['title'] ) ) : ?>
                <h5 class="pxl-item--title"><?php echo pxl_print_html($settings['title']); ?></h5>
            <?php endif; ?>
        </div>
    </div>
</div>