<?php 
if ( ! empty( $settings['team_link']['url'] ) ) {
    $widget->add_render_attribute( 'team_link', 'href', $settings['team_link']['url'] );

    if ( $settings['team_link']['is_external'] ) {
        $widget->add_render_attribute( 'team_link', 'target', '_blank' );
    }

    if ( $settings['team_link']['nofollow'] ) {
        $widget->add_render_attribute( 'team_link', 'rel', 'nofollow' );
    }
} 
$is_new = \Elementor\Icons_Manager::is_migration_allowed(); 
?>
<div class="pxl-team-single pxl-team-single1 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-item--inner">
        <?php if ( !empty($settings['image']['id']) ) : ?>
            <div class="pxl-item--image">
                <?php 
                    $image_size = !empty($settings['img_size']) ? $settings['img_size'] : '600x600';
                    $img  = pxl_get_image_by_size( array(
                        'attach_id'  => $settings['image']['id'],
                        'thumb_size' => $image_size,
                    ) );
                    $thumbnail    = $img['thumbnail'];
                    echo pxl_print_html($thumbnail); 
                ?>
            </div>
        <?php endif; ?>
        <?php if(isset($settings['icons']) && !empty($settings['icons']) && count($settings['icons'])): ?>
            <div class="pxl-item--social">
                <?php foreach ($settings['icons'] as $key => $value):
                    $icon_type = isset($value['icon_type']) ? $value['icon_type'] : '';
                    $icon_image = isset($value['icon_image']) ? $value['icon_image'] : '';
                    $icon_key = $widget->get_repeater_setting_key( 'pxl_icon', 'icons', $key );
                    $widget->add_render_attribute( $icon_key, [
                        'class' => $value['pxl_icon'],
                        'aria-hidden' => 'true',
                    ] );
                    $link_key = $widget->get_repeater_setting_key( 'icon_link', 'value', $key );
                    if ( ! empty( $value['icon_link']['url'] ) ) {
                        $widget->add_render_attribute( $link_key, 'href', $value['icon_link']['url'] );

                        if ( $value['icon_link']['is_external'] ) {
                            $widget->add_render_attribute( $link_key, 'target', '_blank' );
                        }

                        if ( $value['icon_link']['nofollow'] ) {
                            $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                        }
                    }
                    $link_attributes = $widget->get_render_attribute_string( $link_key ); ?>
                    <?php if ( $icon_type == 'icon' && ! empty( $value['pxl_icon'] ) ) : ?>
                        <a class="elementor-repeater-item-<?php echo esc_attr($value['_id']); ?>" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                            <?php if ( $is_new ):
                                \Elementor\Icons_Manager::render_icon( $value['pxl_icon'], [ 'aria-hidden' => 'true' ] );
                            elseif(!empty($value['pxl_icon'])): ?>
                                <i class="<?php echo esc_attr( $value['pxl_icon'] ); ?>" aria-hidden="true"></i>
                            <?php endif; ?>
                        </a>
                    <?php endif; ?>
                    <?php if ( $icon_type == 'image' && !empty($icon_image['id']) ) : 
                        $img_icon  = pxl_get_image_by_size( array(
                            'attach_id'  => $icon_image['id'],
                            'thumb_size' => 'full',
                        ) );
                        $thumbnail_icon    = $img_icon['thumbnail']; ?>
                        <a <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                            <?php echo pxl_print_html($thumbnail_icon); ?>
                        </a>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>