<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_portfolio_info',
        'title' => esc_html__('Portfolio Info PXL', 'industio' ),
        'icon' => 'eicon-post-content',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array( 
                array(
                    'name'     => 'content_section',
                    'label'    => esc_html__( 'Content', 'industio' ),
                    'tab'      => 'content',
                    'controls' => array(
                        array(
                            'name'  => 'max_width',
                            'label' => esc_html__( 'Max Width', 'industio' ),
                            'type'  => 'slider',
                            'control_type' => 'responsive',
                            'range' => [
                                'px' => [
                                    'min' => 100,
                                    'max' => 800,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-portfolio-info' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'style_box',
                            'label' => esc_html__('Display Box', 'industio' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'block' => 'Block',
                                'inline-block' => 'Inline Block',
                            ],
                            'default' => 'inline-block',
                        ),
                        array(
                            'name' => 'list',
                            'label' => esc_html__('List Content Extra', 'industio'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name'     => 'item_label',
                                    'label'    => esc_html__('Item Label', 'industio'),
                                    'type'     => 'text',
                                    'label_block' => true,
                                    'default'  => ''
                                ),
                                array(
                                    'name'     => 'item_content',
                                    'label'    => esc_html__('Item Content', 'industio'),
                                    'type'     => 'text',
                                    'label_block' => true,
                                    'default'  => ''
                                ),
                            ),
                            'title_field' => '{{{ item_label }}}',
                        ),
                    )
                ),  
            ),
        ),
    ),
    industio_get_class_widget_path()
);