<?php
$source = $widget->get_setting('source', '');
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 4);
$post_ids = $widget->get_setting('post_ids', '');
$show_author = $widget->get_setting('show_author');
$show_date = $widget->get_setting('show_date');
extract(pxl_get_posts_of_grid('post', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));
if (is_array($posts)): ?>
    <div class="pxl-blog-list3">
        <div class="pxl-blog-inner">
            <?php
                foreach ($posts as $key => $post): 
                $author = get_user_by('id', $post->post_author);
                ?>
                <div class="pxl-grid-item <?php echo esc_attr( $settings['pxl_animate'] ); ?>">
                    <div class="pxl-item--meta">
                        <ul class="pxl-post--meta field-dflex">
                            <?php if($show_author == 'true'): ?>
                                <li class="pxl-post--author pxl-mr-20 pxl-inline-flex">
                                    <a href="<?php echo esc_url(get_author_posts_url($post->post_author, $author->user_nicename)); ?>">
                                        <?php echo get_avatar( get_the_author_meta( 'ID' ), 90 ); ?>
                                        <?php echo esc_html($author->display_name); ?>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if($show_date == 'true'): ?>
                                <li class="pxl-post--date pxl-mr-20 pxl-inline-flex">
                                    <i class="flaticon-industio-date pxl-mr-5"></i>
                                    <?php echo get_the_date('d M', $post->ID); ?>/<?php echo get_the_date('y', $post->ID); ?>        
                                </li>
                            <?php endif; ?>
                        </ul>
                        <h3 class="pxl-item--title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a></h3>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
<?php endif; ?>