<?php if ( ! empty( $settings['title_link']['url'] ) ) {
    $widget->add_render_attribute( 'title_link', 'href', $settings['title_link']['url'] );

    if ( $settings['title_link']['is_external'] ) {
        $widget->add_render_attribute( 'title_link', 'target', '_blank' );
    }

    if ( $settings['title_link']['nofollow'] ) {
        $widget->add_render_attribute( 'title_link', 'rel', 'nofollow' );
    } ?>
<?php } ?>

<div class="pxl-career-info <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <?php if (!empty($settings['label'])) { ?>
        <label class="pxl--label"><?php echo pxl_print_html($settings['label']); ?></label>
    <?php } ?>
    <<?php echo esc_attr($settings['title_tag']); ?> class="pxl-item--title el-empty">
        <?php if ( ! empty( $settings['title_link']['url'] ) ) { ?><a <?php pxl_print_html($widget->get_render_attribute_string( 'title_link' )); ?>><?php } ?>
            <span><?php echo pxl_print_html($settings['title']); ?></span>
        <?php if ( ! empty( $settings['title_link']['url'] ) ) { ?></a><?php } ?>
    </<?php echo esc_attr($settings['title_tag']); ?>>
    <?php if(isset($settings['lists']) && !empty($settings['lists']) && count($settings['lists'])): ?>
    <ul class="list-brc">
        <?php foreach ($settings['lists'] as $key => $value): ?>
             <?php if(!empty($value['list_item'])) : ?>
                <li><?php echo pxl_print_html($value['list_item']); ?></li>
            <?php endif; ?>
        <?php endforeach; ?>
    </ul>
    <?php endif; ?>
</div>
