<?php
$widget->add_render_attribute( 'counter', [
    'class' => 'pxl-counter--value '.$settings['effect'].'',
    'data-duration' => $settings['duration'],
    'data-startnumber' => $settings['starting_number'],
    'data-endnumber' => $settings['ending_number'],
    'data-to-value' => $settings['ending_number'],
    'data-delimiter' => $settings['thousand_separator_char'],
] ); ?>
<div class="pxl-counter pxl-counter3 <?php echo esc_attr( $settings['pxl_animate'] ); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="wp-box-image">
        <div class="wp-bg-image">
            <div class="inner-bg-image bg-image" <?php if(!empty($settings['bg_image']['id'])) { ?>style="background-image: url(<?php echo esc_url($settings['bg_image']['url']); ?>);"<?php } ?>></div>
        </div>
        <div class="pxl-image">
            <?php $man_image  = pxl_get_image_by_size( array(
                    'attach_id'  => $settings['man_image']['id'],
                    'thumb_size' => 'full',
                ) );
                $thumbnail    = $man_image['thumbnail'];
            echo pxl_print_html($thumbnail); ?>
        </div>
    </div>
    <div class="box-counter">
        <div class="pxl-counter--number">
            <span class="pxl-counter--prefix el-empty"><?php echo pxl_print_html($settings['prefix']); ?></span>
            <span <?php pxl_print_html($widget->get_render_attribute_string( 'counter' )); ?>><?php echo esc_html($settings['starting_number']); ?></span>
            <?php if(!empty($settings['suffix'])) : ?>
                <span class="pxl-counter--suffix"><?php echo pxl_print_html($settings['suffix']); ?></span>
            <?php endif; ?>
        </div>
        <div class="pxl-meta">
            <?php if(!empty($settings['title_suffix'])) : ?>
                <span class="pxl-suffix-title"><?php echo pxl_print_html($settings['title_suffix']); ?></span>
            <?php endif; ?>
            <?php if(!empty($settings['title'])) : ?>
                <div class="pxl-counter--title"><?php echo pxl_print_html($settings['title']); ?></div>
            <?php endif; ?>
        </div>
    </div>
</div>