<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');
$arrows = $widget->get_setting('arrows','false');  
$arrows_position = $widget->get_setting('arrows_position', 'arrows-bottom');
$pagination = $widget->get_setting('pagination','false');
$pagination_type = $widget->get_setting('pagination_type','bullets');

$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite','false');  
$speed = $widget->get_setting('speed', '500');
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => '1', 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => 1,
    'slides_to_show_xxl'            => 1, 
    'slides_to_show_lg'             => 1, 
    'slides_to_show_md'             => 1, 
    'slides_to_show_sm'             => 1, 
    'slides_to_show_xs'             => 1, 
    'slides_to_scroll'              => 1,
    'arrow'                         => $arrows,
    'pagination'                    => $pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => $autoplay,
    'pause_on_hover'                => $pause_on_hover,
    'pause_on_interaction'          => 'true',
    'delay'                         => $autoplay_speed,
    'loop'                          => $infinite,
    'speed'                         => $speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
$img_size = isset($settings['img_size']) ? $settings['img_size'] : '';
$image_size = !empty($img_size) ? $img_size : 'full';
$html_id = pxl_get_element_id($settings);
if(isset($settings['content']) && !empty($settings['content']) && count($settings['content'])): ?>
    <div class="pxl-swiper-slider pxl-feature-slide" data-arrow="<?php echo esc_attr($arrows); ?>">
        <div class="pxl-carousel-inner">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php foreach ($settings['content'] as $key => $value):
                        $image_bg = isset($value['image_bg']) ? $value['image_bg'] : '';
                        $feature_label = isset($value['feature_label']) ? $value['feature_label'] : '';
                        $product_title = isset($value['product_title']) ? $value['product_title'] : '';
                        $product_excert = isset($value['product_excert']) ? $value['product_excert'] : '';
                        $btn_text = isset($value['btn_text']) ? $value['btn_text'] : '';
                        $link = isset($value['link']) ? $value['link'] : '';
                        $link_key = $widget->get_repeater_setting_key( 'title', 'value', $key );
                        if ( ! empty( $link['url'] ) ) {
                            $widget->add_render_attribute( $link_key, 'href', $link['url'] );

                            if ( $link['is_external'] ) {
                                $widget->add_render_attribute( $link_key, 'target', '_blank' );
                            }

                            if ( $link['nofollow'] ) {
                                $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                            }
                        }
                        $link_attributes = $widget->get_render_attribute_string( $link_key );
                        $img_feature = pxl_get_image_by_size( array(
                            'attach_id'  => $image_bg['id'],
                            'thumb_size' => $image_size,
                            'class' => 'no-lazyload',
                        ));
                        $thumbnail_feature = $img_feature['thumbnail'];
                        $thumbnail_feature_url    = $img_feature['url'];
                        ?>
                        <div class="pxl-swiper-slide">
                            <div class="pxl-item--inner">
                                <div class="bg-image bg-feature-image" <?php if(!empty($image_bg['id'])) { ?> style="background-image: url(<?php echo wp_kses_post($thumbnail_feature_url); ?>);" <?php } ?>></div>
                                <div class="bg-overlay elementor-repeater-item-<?php echo esc_attr($value['_id']); ?>"></div>
                                <div class="pxl-item-meta">
                                    <div class="pxl-item--label el-empty"><?php echo pxl_print_html($feature_label); ?></div>
                                    <h2 class="pxl-item--title pxl-empty">
                                        <?php echo pxl_print_html($product_title); ?>
                                    </h2>
                                    <div class="pxl-item--desc el-empty"><?php echo pxl_print_html($product_excert); ?></div>
                                    <a class="btn btn-icon-box2" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                                        <span class="pxl--btn-text"><?php echo pxl_print_html($value['btn_text']); ?></span>
                                        <span class="pxl--btn-icon"><i class="bootstrap-icons bi-arrow-right-short"></i></span>
                                    </a>
                                </div>
                           </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        
        <div class="grap-arrows <?php echo esc_attr($settings['style_navi']); ?>">
            <?php  if($arrows !== 'false') { ?>
                <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><i class="caseicon caseicon-long-arrow-right-two"></i></div>
                <?php } ?>
                <?php if($pagination !== 'false'): ?>
                    <div class="pxl-swiper-dots"></div>
                <?php endif; ?>
                <?php  if($arrows !== 'false') { ?>
                <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><i class="caseicon caseicon-long-arrow-right-two"></i></div>
            <?php } ?>
        </div>
    </div>
<?php endif; ?>