<?php if(isset($settings['lists']) && !empty($settings['lists']) && count($settings['lists'])): ?>
    <div class="pxl-list pxl-list1 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
        <?php foreach ($settings['lists'] as $key => $value): ?>
            <div class="pxl--item">
                <div class="pxl-item--meta">
                    <?php if ( $settings['icon_type'] == 'icon' && !empty($settings['pxl_icon']['value']) ) : ?>
                        <div class="pxl-item--icon <?php if($settings['icon_color_type'] == 'gradient') { echo 'pxl-icon-color-gradient'; } ?>">
                            <?php \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
                        </div>
                    <?php endif; ?>
                    <?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : 
                        $img_icon  = pxl_get_image_by_size( array(
                            'attach_id'  => $settings['icon_image']['id'],
                            'thumb_size' => 'full',
                        ) );
                        $thumbnail_icon    = $img_icon['thumbnail']; ?>
                        <div class="pxl-item--icon"><?php echo pxl_print_html($thumbnail_icon); ?></div>
                    <?php endif; ?>
                </div>
                <?php if(!empty($value['content'])) : ?>
                    <div class="pxl-item--content">
                        <label class="pxl-empty"><?php echo pxl_print_html($value['label']); ?></label>
                        <?php echo pxl_print_html($value['content'])?>
                    </div>
                <?php endif; ?>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>