<?php
$html_id = pxl_get_element_id($settings);
if ( ! empty( $settings['link_button']['url'] ) ) {
    $widget->add_render_attribute( 'link_text2', 'href', $settings['link_button']['url'] );

    if ( $settings['link_button']['is_external'] ) {
        $widget->add_render_attribute( 'link_text2', 'target', '_blank' );
    }

    if ( $settings['link_button']['nofollow'] ) {
        $widget->add_render_attribute( 'link_text2', 'rel', 'nofollow' );
    }
}
?>
<div class="pxl-list-meta pxl-list-meta4">
	<?php if(isset($settings['lists_lv4']) && !empty($settings['lists_lv4']) && count($settings['lists_lv4'])):
	$is_new = \Elementor\Icons_Manager::is_migration_allowed(); ?>
		<div class="pxl-meta-inner">
			<?php foreach ($settings['lists_lv4'] as $key => $value):
				$icon_key = $widget->get_repeater_setting_key( 'pxl_icon_lv4', 'icons', $key );
	            $widget->add_render_attribute( $icon_key, [
	                'class' => $value['pxl_icon_lv4'],
	                'aria-hidden' => 'true',
	            ] );
			 	?>
	            <div class="pxl-item <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
	            	<div class="pxl-icon-title">
	            		<?php if ( ! empty( $value['pxl_icon_lv4'] ) ) : ?>
	                        <span class="pxl-item--icon pxl-mr-9">
	                            <?php if ( $is_new ):
	                                \Elementor\Icons_Manager::render_icon( $value['pxl_icon_lv4'], [ 'aria-hidden' => 'true' ] );
	                            elseif(!empty($value['pxl_icon_lv4'])): ?>
	                                <i class="<?php echo esc_attr( $value['pxl_icon_lv4'] ); ?>" aria-hidden="true"></i>
	                            <?php endif; ?>
	                        </span>
	                    <?php endif; ?>
	                    <span class="pxl-item--title">
			                <?php echo pxl_print_html($value['title_lv4'])?>
		                </span>
	            	</div>
	            	<div class="pxl-sub--title">
		                <?php echo pxl_print_html($value['sub_title'])?>
	                </div>
	            </div>
	        <?php endforeach; ?>
		</div>
	<?php endif; ?>
	<div class="pxl-item-button">
		<a <?php pxl_print_html($widget->get_render_attribute_string( 'link_text2' )); ?>>
			<?php echo esc_attr($settings['title_link_btn']); ?>
		</a>
	</div>
</div>