<?php 
extract($settings);
if(!is_singular( 'portfolio' )) return;
$post_id = get_the_ID();
$client = get_post_meta( $post_id, 'client', true );
$date_start = get_post_meta( $post_id, 'date_start', true);
$date_end = get_post_meta( $post_id, 'date_end', true);
$price = get_post_meta( $post_id, 'price', true);
$term_list = get_the_term_list( $post_id, 'portfolio-category', '', ' ', '' );
$tag_list = get_the_term_list( $post_id, 'portfolio-tag', '', ' ', '' );
?>
<div class="pxl-portfolio-info">
	<div class="content-inner">
		<?php if( is_singular( 'portfolio' ) && $post_id > 0 ) { ?>
			<?php if ( !empty( $client ) ) : ?> 
				<div class="content-item client">
					<span class="lbl d-block"><?php echo esc_html__( 'Clients:', 'industio' ) ?></span>
					<span class="item-text"><?php pxl_print_html($client) ?></span>
				</div>
			<?php endif; ?>
			<?php if ( !is_wp_error( $term_list ) ) : ?> 
				<div class="content-item type-category">
					<span class="lbl d-block"><?php echo esc_html__( 'Category:', 'industio' ) ?></span>
					<?php the_terms( $post_id, 'portfolio-category', '', ' ' ); ?>
				</div>
			<?php endif; ?>
			<?php if ( !empty( $date_start ) ) : ?> 
				<div class="content-item date">
					<span class="lbl d-block"><?php echo esc_html__( 'Start Date:', 'industio' ) ?></span>
					<span class="item-text"><?php pxl_print_html( date('F d, Y', strtotime($date_start) )); ?></span>
				</div>
			<?php endif; ?>
			<?php if ( !empty( $date_end ) ) : ?> 
				<div class="content-item date">
					<span class="lbl d-block"><?php echo esc_html__( 'End Date:', 'industio' ) ?></span>
					<span class="item-text"><?php pxl_print_html( date('F d, Y', strtotime($date_end) )); ?></span>
				</div>
			<?php endif; ?>
			<?php if ( !empty($price) || !empty($currency) ) : ?> 
				<div class="content-item price">
					<span class="lbl d-block"><?php echo esc_html__( 'Price:', 'industio' ) ?></span>
					<span class="item-text"><?php pxl_print_html($price) ?></span>
				</div>
			<?php endif; ?>
		<?php } ?>
		<?php if(isset($list) && !empty($list) && count($list)): 
        	foreach ($list as $key => $pxl_list): ?>
	            <div class="content-item">
	                <?php if ( !empty( $pxl_list['item_label'] ) ) : ?> 
	                	<span class="lbl d-block"><?php pxl_print_html($pxl_list['item_label'])?></span>
	                <?php endif; ?>
	                <?php if ( !empty( $pxl_list['item_content'] ) ) : ?> 
	                	<span class="item-text"><?php pxl_print_html($pxl_list['item_content'])?></span>
	                <?php endif; ?>
	           </div>
	        <?php endforeach; ?>
		<?php endif; ?>

	</div>
</div>