<?php
$source = $widget->get_setting('source', '');
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 4);
$post_ids = $widget->get_setting('post_ids', '');
extract(pxl_get_posts_of_grid('service', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));
if (is_array($posts)): ?>
    <div class="pxl-service-list pxl-service-list1 <?php echo esc_attr( $settings['style'] ); ?>">
        <div class="pxl-service-inner">
            <ul>
                <?php foreach ($posts as $key => $post): ?>
                    <li class="pxl-item--title <?php echo esc_attr( $settings['pxl_animate'] ); ?>">
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                            <span>
                                <i class="flaticon flaticon-top"></i>
                                <?php echo esc_html(get_the_title($post->ID)); ?>
                            </span>
                        </a>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>
<?php endif; ?>