<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll');
$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', 5000);
$infinite = $widget->get_setting('infinite', false);  
$speed = $widget->get_setting('speed', 500);
$drap = $widget->get_setting('drap', false);
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => (int)$col_xl,
    'slides_to_show_xxl'            => (int)$col_xxl, 
    'slides_to_show_lg'             => (int)$col_lg, 
    'slides_to_show_md'             => (int)$col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
if(isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])): ?>
    <div class="pxl-swiper-slider pxl-testimonial-carousel pxl-testimonial-carousel1" <?php if($drap !== false) : ?>data-cursor-drap="<?php echo esc_attr__('DRAG', 'industio'); ?>"<?php endif; ?>>
        <div class="pxl-carousel-inner">

            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php foreach ($settings['testimonial'] as $key => $value):
                        $title = isset($value['title']) ? $value['title'] : '';
                        $position = isset($value['position']) ? $value['position'] : '';
                        $desc = isset($value['description']) ? $value['description'] : '';
                        $image = isset($value['image']) ? $value['image'] : '';
                        ?>
                        <div class="pxl-swiper-slide">
                            <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate']); ?>">
                                <?php if(!empty($image['id'])) { 
                                    $img = pxl_get_image_by_size( array(
                                        'attach_id'  => $image['id'],
                                        'thumb_size' => '128x128',
                                        'class' => 'no-lazyload',
                                    ));
                                    $thumbnail = $img['thumbnail'];?>
                                    <div class="pxl-item--image pxl-mr-20">
                                        <div class="pxl-item--avatar">
                                            <?php echo wp_kses_post($thumbnail); ?>
                                        </div>
                                        <svg width="53" height="41" viewBox="0 0 53 41" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M5.51211 36.8875C2.63711 33.725 0.912109 30.275 0.912109 24.525C0.912109 14.4625 8.09961 5.54995 18.1621 0.949951L20.7496 4.68745C11.2621 9.86245 9.24961 16.475 8.67461 20.7875C10.1121 19.925 12.1246 19.6375 14.1371 19.925C19.3121 20.5 23.3371 24.525 23.3371 29.9875C23.3371 32.575 22.1871 35.1624 20.4621 37.1749C18.4496 39.1875 16.1496 40.0499 13.2746 40.0499C10.1121 40.0499 7.23711 38.6125 5.51211 36.8875ZM34.2621 36.8875C31.3871 33.725 29.6621 30.275 29.6621 24.525C29.6621 14.4625 36.8496 5.54995 46.9121 0.949951L49.4996 4.68745C40.0121 9.86245 37.9996 16.475 37.4246 20.7875C38.8621 19.925 40.8746 19.6375 42.8871 19.925C48.0621 20.5 52.0871 24.525 52.0871 29.9875C52.0871 32.575 50.9371 35.1624 49.2121 37.1749C47.4871 39.1875 44.8996 40.0499 42.0246 40.0499C38.8621 40.0499 35.9871 38.6125 34.2621 36.8875Z" fill="black"/>
                                        </svg>
                                    </div>
                                <?php } ?>
                                <div class="pxl-item--meta">
                                    <div class="pxl-item--desc el-empty"><?php echo pxl_print_html($desc); ?></div>
                                    <h6 class="pxl-item--title el-empty"><?php echo pxl_print_html($title); ?></h6>
                                    <?php if(!empty($position)) : ?>
                                        <div class="pxl-item--position"><?php echo pxl_print_html($position); ?></div>
                                    <?php endif; ?>                            
                                </div>
                           </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

        </div>
        
        <?php if($pagination !== false): ?>
            <div class="pxl-swiper-dots style-1"></div>
        <?php endif; ?>

        <?php if($arrows !== false): ?>
            <div class="pxl-swiper-arrow-wrap style-1">
                <div class="pxl-swiper-arrow pxl-swiper-arrow-prev pxl-cursor--cta"><i class="flaticon-left-chevron rtl-icon"></i></div>
                <div class="pxl-swiper-arrow pxl-swiper-arrow-next pxl-cursor--cta"><i class="flaticon-right-chevron rtl-icon"></i></div>
            </div>
        <?php endif; ?>
        
    </div>
<?php endif; ?>
