<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_list_meta',
        'title' => esc_html__('List Meta Pxl', 'industio'),
        'icon' => 'eicon-posts-ticker',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'elementor-waypoints',
            'jquery-numerator',
            'pxl-counter',
            'industio-counter',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'industio' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'industio' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'industio' ),
                                    'image' => get_template_directory_uri() . '/elements/templates/pxl_list_meta/img-layout/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'industio' ),
                                    'image' => get_template_directory_uri() . '/elements/templates/pxl_list_meta/img-layout/layout2.jpg'
                                ],
                                '3' => [
                                    'label' => esc_html__('Layout 3', 'industio' ),
                                    'image' => get_template_directory_uri() . '/elements/templates/pxl_list_meta/img-layout/layout3.jpg'
                                ],
                                '4' => [
                                    'label' => esc_html__('Layout 4', 'industio' ),
                                    'image' => get_template_directory_uri() . '/elements/templates/pxl_list_meta/img-layout/layout4.jpg'
                                ],
                                '5' => [
                                    'label' => esc_html__('Layout 5', 'industio' ),
                                    'image' => get_template_directory_uri() . '/elements/templates/pxl_list_meta/img-layout/layout5.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'industio'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'lists',
                            'label' => esc_html__('Content', 'industio'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'condition' => [
                                'layout' => ['1','2'],
                            ],
                            'controls' => array(
                                array(
                                    'name' => 'pxl_icon',
                                    'label' => esc_html__('Icon', 'industio' ),
                                    'type' => \Elementor\Controls_Manager::ICONS,
                                    'fa4compatibility' => 'icon',
                                ),
                                array(
                                    'name' => 'title',
                                    'label' => esc_html__('Title', 'industio'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'link',
                                    'label' => esc_html__('Link', 'industio'),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'label_block' => true,
                                ),
                            ),
                            'title_field' => '{{{ title }}}',
                        ),
                        array(
                            'name' => 'lists_lv3',
                            'label' => esc_html__('Content Lv3', 'industio'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'condition' => [
                                'layout' => ['3','5'],
                            ],
                            'controls' => array(
                                array(
                                    'name' => 'title_lv3',
                                    'label' => esc_html__('Title Lv3', 'industio'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                            ),
                            'title_field' => '{{{ title_lv3 }}}',
                        ),
                        array(
                            'name' => 'lists_lv4',
                            'label' => esc_html__('Content Lv4', 'industio'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'condition' => [
                                'layout' => ['4'],
                            ],
                            'controls' => array(
                                array(
                                    'name' => 'pxl_icon_lv4',
                                    'label' => esc_html__('Icon', 'industio' ),
                                    'type' => \Elementor\Controls_Manager::ICONS,
                                    'fa4compatibility' => 'icon',
                                ),
                                array(
                                    'name' => 'title_lv4',
                                    'label' => esc_html__('Title Lv4', 'industio'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'sub_title',
                                    'label' => esc_html__('Sub Title', 'industio'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                            ),
                            'title_field' => '{{{ title_lv4 }}}',
                        ),
                        array(
                            'name' => 'title_link_btn',
                            'label' => esc_html__('Title Link BTN', 'industio'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            'condition' => [
                                'layout' => ['4'],
                            ],
                        ),
                        array(
                            'name' => 'link_button',
                            'label' => esc_html__('Link BTN', 'industio' ),
                            'type' => \Elementor\Controls_Manager::URL,
                            'condition' => [
                                'layout' => ['4'],
                            ],
                            'default' => [
                                'url' => '#',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style',
                    'label' => esc_html__('Style', 'industio' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'style',
                            'label' => esc_html__('Style', 'industio' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'condition' => [
                                'layout' => ['1','2'],
                            ],
                            'options' => [
                                'style1' => 'Style1',
                            ],
                            'default' => 'style1',
                        ),
                        array(
                            'name' => 'icon_font_size',
                            'label' => esc_html__('Icon Size', 'industio' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'condition' => [
                                'layout' => ['1','2'],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-list-meta .pxl-meta-inner .pxl-item--icon' => 'font-size: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .pxl-list-meta .pxl-meta-inner .pxl-item--icon svg' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Color', 'industio' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'condition' => [
                                'layout' => ['1','2'],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-list-meta .pxl-meta-inner a' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'title_color_hover',
                            'label' => esc_html__('Color Hover', 'industio' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'condition' => [
                                'layout' => ['1','2'],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-list-meta .pxl-meta-inner a:hover' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Typography', 'industio' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'condition' => [
                                'layout' => ['1','2'],
                            ],
                            'selector' => '{{WRAPPER}} .pxl-list-meta .pxl-meta-inner a',
                        ),
                        array(
                            'name' => 'title_lv3_color',
                            'label' => esc_html__('Title Lv3 Color', 'industio' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'condition' => [
                                'layout' => ['3','5'],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-list-meta .pxl-meta-inner .pxl-item--title' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'title_lv3_typography',
                            'label' => esc_html__('Title Lv3 Typography', 'industio' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'condition' => [
                                'layout' => ['3','5'],
                            ],
                            'selector' => '{{WRAPPER}} .pxl-list-meta .pxl-meta-inner .pxl-item--title',
                        ),
                        array(
                            'name' => 'pxl_animate',
                            'label' => esc_html__('Animate - Primary Meta', 'industio' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => industio_widget_animate(),
                            'default' => '',
                        ),
                        array(
                            'name' => 'pxl_animate_delay',
                            'label' => esc_html__('Animate Delay - Primary Meta', 'industio' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '0',
                            'description' => 'Enter number. Default 0ms',
                        ),
                    ),
                ),
            ),
        ),
    ),
    industio_get_class_widget_path()
);