<?php if(!function_exists('industio_configs')){
    function industio_configs($value){
        $configs = [
            'theme_colors' => [
                'primary'   => [
                    'title' => esc_html__('Primary', 'industio'), 
                    'value' => industio()->get_opt('primary_color', '#fc5a0f')
                ],
                'secondary'   => [
                    'title' => esc_html__('Secondary', 'industio'), 
                    'value' => industio()->get_opt('secondary_color', '#190200')
                ],
                'third'   => [
                    'title' => esc_html__('Third', 'industio'), 
                    'value' => industio()->get_opt('third_color', '#717171')
                ],
                'dark'   => [
                    'title' => esc_html__('Dark', 'industio'), 
                    'value' => industio()->get_opt('dark_color', '#000')
                ],
                'light'   => [
                    'title' => esc_html__('Light', 'industio'), 
                    'value' => industio()->get_opt('light_color', '#fff')
                ],
                'body-bg'   => [
                    'title' => esc_html__('Body Background Color', 'industio'), 
                    'value' => industio()->get_page_opt('body_bg_color', '#fff')
                ],
            ],
            'link' => [
                'color' => industio()->get_opt('link_color', ['regular' => '#fc5a0f'])['regular'],
                'color-hover'   => industio()->get_opt('link_color', ['hover' => '#fc5a0f'])['hover'],
                'color-active'  => industio()->get_opt('link_color', ['active' => '#fc5a0f'])['active'],
            ],
            'gradient' => [
                'color-from' => industio()->get_opt('gradient_color', ['from' => '#fc5a0f'])['from'],
                'color-to' => industio()->get_opt('gradient_color', ['to' => '#fe0054'])['to'],
            ],
               
        ];
        return $configs[$value];
    }
}
if(!function_exists('industio_inline_styles')) {
    function industio_inline_styles() {  
        
        $theme_colors      = industio_configs('theme_colors');
        $link_color        = industio_configs('link');
        $gradient_color    = industio_configs('gradient');

        ob_start();
        echo ':root{';
            
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color: %2$s;', str_replace('#', '',$color),  $value['value']);
            }
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color-rgb: %2$s;', str_replace('#', '',$color),  industio_hex_rgb($value['value']));
            }
            foreach ($link_color as $color => $value) {
                printf('--link-%1$s: %2$s;', $color, $value);
            }
            foreach ($gradient_color as $color => $value) {
                printf('--gradient-%1$s: %2$s;', $color, $value);
            }

        echo '}';

        return ob_get_clean();
         
    }
}
 