<?php
 
add_action( 'pxl_post_metabox_register', 'industio_page_options_register' );
function industio_page_options_register( $metabox ) {
 
	$panels = [
		'post' => [
			'opt_name'            => 'post_option',
			'display_name'        => esc_html__( 'Post Options', 'industio' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'Post Header', 'industio' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
				        industio_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'post_title' => [
					'title'  => esc_html__( 'Post Title', 'industio' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        industio_post_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'post_settings' => [
					'title'  => esc_html__( 'Post Options', 'industio' ),
					'icon'   => 'el el-cog',
					'fields' => array_merge(
						industio_sidebar_pos_opts(['prefix' => 'post_', 'default' => true, 'default_value' => '-1']),
						array(
							array(
					            'id'=> 'post_video_link',
					            'type' => 'text',
					            'title' => esc_html__('Video Link', 'industio'),
					            'validate' => 'url',
					            'default' => '',
					        ),
	                        array(
								'id'       => 'featured-gallery',
								'type'     => 'gallery',
								'title'    => esc_html__( 'Gallery Images ', 'industio' ),
								'subtitle' => esc_html__( 'Upload images or add from media library.', 'industio' )
							),
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'industio' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
					    )
					)
				]
			]
		],
		'page' => [
			'opt_name'            => 'pxl_page_options',
			'display_name'        => esc_html__( 'Page Options', 'industio' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'Header', 'industio' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
				        industio_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						industio_header_mobile_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
				                'id'       => 'header_display',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Header Display', 'industio'),
				                'options'  => array(
				                    'show' => esc_html__('Show', 'industio'),
				                    'hide'  => esc_html__('Hide', 'industio'),
				                ),
				                'default'  => 'show',
				            ),
				            array(
				                'id'       => 'page_mobile_style',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Mobile Style', 'industio'),
				                'options'  => array(
				                    'inherit'  => esc_html__('Inherit', 'industio'),
				                    'light'  => esc_html__('Light', 'industio'),
				                    'dark'  => esc_html__('Dark', 'industio'),
				                ),
				                'default'  => 'inherit',
				            ),
				            array(
				           		'id'       => 'logo_m',
					            'type'     => 'media',
					            'title'    => esc_html__('Mobile Logo Dark', 'industio'),
					            'default'  => '',
					            'url'      => false,
					        ),
					        array(
				           		'id'       => 'logo_light_m',
					            'type'     => 'media',
					            'title'    => esc_html__('Mobile Logo Light', 'industio'),
					            'default'  => '',
					            'url'      => false,
					        ),
					        array(
				                'id'       => 'p_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu', 'industio' ),
				                'options'  => industio_get_nav_menu_slug(),
				                'default' => '',
				                'description' => 'When you select Custom Menu. The custom menu will apply to the entire layout when you use Case Nav Menu widget in Elementor and Menu on header layout in Mobile.'
				            ),
					    ),
					    array(
				            array(
				                'id'       => 'sticky_scroll',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Sticky Scroll', 'industio'),
				                'options'  => array(
				                    '-1' => esc_html__('Inherit', 'industio'),
				                    'pxl-sticky-stt' => esc_html__('Scroll To Top', 'industio'),
				                    'pxl-sticky-stb'  => esc_html__('Scroll To Bottom', 'industio'),
				                ),
				                'default'  => '-1',
				            ),
				            array(
				                'id'       => 'header_margin',
				                'type'     => 'spacing',
				                'mode'     => 'margin',
				                'title'    => esc_html__('Margin', 'industio'),
				                'width'    => false,
				                'unit'     => 'px',
				                'output'    => array('#pxl-header-elementor .pxl-header-elementor-main'),
				            ),
				        )
				    )
					 
				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'industio' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        industio_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'content' => [
					'title'  => esc_html__( 'Content', 'industio' ),
					'icon'   => 'el-icon-pencil',
					'fields' => array_merge(
						industio_sidebar_pos_opts(['prefix' => 'page_', 'default' => false, 'default_value' => '0']),
						array(
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'industio' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							), 
							array(
					        	'id'           => 'loading_page',
					        	'type'         => 'button_set',
					        	'title'        => esc_html__( 'Loading', 'industio' ),
					        	'options'      => array(
					        		'-1'  	   => esc_html__( 'Inherit', 'industio' ),
					        		'bd' 	   => esc_html__( 'Builder', 'industio' ),
					        	),
					        	'default'      => '-1',
					        ),
					        array(
					            'id'       => 'site_loader_style',
					            'type'     => 'button_set',
					            'title'    => esc_html__('Site Loader Style', 'industio'),
					            'options'  => array(
					                'style-1' => esc_html__('Style 1', 'industio'),
					                'style-2' => esc_html__('Style 2', 'industio'),
					                'style-3' => esc_html__('Oil Gas', 'industio'),
					                'style-4' => esc_html__('Spin', 'industio'),
					                'style-5' => esc_html__('Experiment', 'industio'),
					            ),
					            'default'  => 'style-4',
					            'required' => array( 0 => 'loading_page', 1 => 'equals', 2 => 'bd' ),
					            'force_output' => true
					        ),

					        array(
					            'id'       => 'site_loader_icon',
					            'type'     => 'media',
					            'title'    => esc_html__('Site Loader Icon', 'industio'),
					            'default' => '',
					            'url'      => false,
					            'required'       => array( 0 => 'site_loader_style', 1 => 'equals', 2 => ['style-2', 'style-4'] ),
					            'force_output' => true
					        ),
					    )
					)
				],
				'footer' => [
					'title'  => esc_html__( 'Footer', 'industio' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        industio_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
				                'id'       => 'footer_display',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Footer Display', 'industio'),
				                'options'  => array(
				                    'show' => esc_html__('Show', 'industio'),
				                    'hide'  => esc_html__('Hide', 'industio'),
				                ),
				                'default'  => 'show',
				            ),
							array(
				                'id'       => 'p_footer_fixed',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Footer Fixed', 'industio'),
				                'options'  => array(
				                    'inherit' => esc_html__('Inherit', 'industio'),
				                    'on' => esc_html__('On', 'industio'),
				                    'off' => esc_html__('Off', 'industio'),
				                ),
				                'default'  => 'inherit',
				            ),
				            array(
				                'id'       => 'back_top_top_style',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Back to Top Style', 'industio'),
				                'options'  => array(
				                    'style-default' => esc_html__('Default', 'industio'),
				                    'style-round' => esc_html__('Round', 'industio'),
				                ),
				                'default'  => 'style-default',
				            ),
						)
				    )
				],
				'colors' => [
					'title'  => esc_html__( 'Colors', 'industio' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        array(
				        	array(
							    'id'        => 'page_body_color',
							    'type'      => 'color',
							    'title'     => esc_html__('Body Background Color', 'industio'),
							    'default'   => '',
							    'transparent' => false,
							    'output'    => array(
							        'background-color' => 'body',
							    )
							),
				        	array(
					            'id'          => 'primary_color',
					            'type'        => 'color',
					            'title'       => esc_html__('Primary Color', 'industio'),
					            'transparent' => false,
					            'default'     => ''
					        ),
					        array(
					            'id'          => 'gradient_color',
					            'type'        => 'color_gradient',
					            'title'       => esc_html__('Gradient Color', 'industio'),
					            'transparent' => false,
					            'default'  => array(
					                'from' => '',
					                'to'   => '', 
					            ),
					        ),
					    )
				    )
				],
				'extra' => [
					'title'  => esc_html__( 'Extra', 'industio' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        array(
				        	array(
					            'id' => 'body_custom_class',
					            'type' => 'text',
					            'title' => esc_html__('Body Custom Class', 'industio'),
					        ),
					    )
				    )
				]
			]
		],
		'portfolio' => [
			'opt_name'            => 'pxl_portfolio_options',
			'display_name'        => esc_html__( 'Portfolio Options', 'industio' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'industio' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
						    array(
						        'id'          => 'list_meta',
						        'type'        => 'multi_text',
						        'title'       => esc_html__('List Info Extra', 'industio')
						    ),
							array(
								'id'       => 'portfolio_video_link',
								'type'     => 'text',
								'title'    => esc_html__( 'Video Link', 'industio' ),
								'validate' => 'url',
								'msg'      => 'Url error!'
							),
							array(
					            'id'=> 'portfolio_excerpt',
					            'type' => 'textarea',
					            'title' => esc_html__('Excerpt', 'industio'),
					            'validate' => 'html_custom',
					            'default' => '',
					        ),
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Spacing Top/Bottom', 'industio' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
						)
				    )
				],
				'port_meta' => [
					'title'  => esc_html__( 'Meta', 'industio' ),
					'icon'   => 'el-icon-website',
					'fields' => array(
					 	array(
				            'id'          => 'client',
				            'type'        => 'text',
				            'title'       => esc_html__('Client', 'industio'),
				            'default'     => ''
				        ),
					 	array(
				            'id'          => 'location',
				            'type'        => 'text',
				            'title'       => esc_html__('Location', 'industio'),
				            'default'     => ''
				        ),
				        array(
					        'id'          => 'date_start',
					        'type'        => 'date',
					        'title'       => esc_html__('Date Start', 'industio')
					    ),
				        array(
					        'id'          => 'date_end',
					        'type'        => 'date',
					        'title'       => esc_html__('Date End', 'industio')
					    ),
					    array(
					        'id'          => 'price',
					        'type'        => 'text',
					        'title'       => esc_html__('Regular price', 'industio')
					    ),
					)
				],
			]
		],
		'service' => [
			'opt_name'            => 'pxl_service_options',
			'display_name'        => esc_html__( 'Service Options', 'industio' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'industio' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
							array(
					            'id'       => 'service_external_link',
					            'type'     => 'text',
					            'title'    => esc_html__('External Link', 'industio'),
					            'validate' => 'url',
					            'default'  => '',
					        ),
							array(
					            'id'=> 'service_excerpt',
					            'type' => 'textarea',
					            'title' => esc_html__('Excerpt', 'industio'),
					            'validate' => 'html_custom',
					            'default' => '',
					        ),
					        array(
					            'id'       => 'service_icon_type',
					            'type'     => 'button_set',
					            'title'    => esc_html__('Icon Type', 'industio'),
					            'options'  => array(
					                'icon'  => esc_html__('Icon', 'industio'),
					                'image'  => esc_html__('Image', 'industio'),
					            ),
					            'default'  => 'icon'
					        ),
					        array(
					            'id'       => 'service_icon_font',
					            'type'     => 'pxl_iconpicker',
					            'title'    => esc_html__('Icon', 'industio'),
					            'required' => array( 0 => 'service_icon_type', 1 => 'equals', 2 => 'icon' ),
            					'force_output' => true
					        ),
					        array(
					            'id'       => 'service_icon_img',
					            'type'     => 'media',
					            'title'    => esc_html__('Icon Image', 'industio'),
					            'default' => '',
					            'required' => array( 0 => 'service_icon_type', 1 => 'equals', 2 => 'image' ),
				            	'force_output' => true
					        ),
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Spacing Top/Bottom', 'industio' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
						),
						industio_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
			]
		],

		'pxl-template' => [ //post_type
			'opt_name'            => 'pxl_hidden_template_options',
			'display_name'        => esc_html__( 'Template Options', 'industio' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'industio' ),
					'icon'   => 'el-icon-website',
					'fields' => array(
						array(
							'id'    => 'template_type',
							'type'  => 'select',
							'title' => esc_html__('Type', 'industio'),
				            'options' => [
				            	'df'       	   => esc_html__('Select Type', 'industio'), 
								'header'       => esc_html__('Header Desktop', 'industio'),
								'header-mobile'       => esc_html__('Header Mobile', 'industio'),
								'footer'       => esc_html__('Footer', 'industio'), 
								'mega-menu'    => esc_html__('Mega Menu', 'industio'), 
								'page-title'   => esc_html__('Page Title', 'industio'), 
								'tab' => esc_html__('Tab', 'industio'),
								'hidden-panel' => esc_html__('Hidden Panel', 'industio'),
								'popup' => esc_html__('Popup', 'industio'),
								'page' => esc_html__('Page', 'industio'),
								'slider' => esc_html__('Slider', 'industio'),
				            ],
				            'default' => 'df',
				        ),
				        array(
							'id'    => 'header_type',
							'type'  => 'select',
							'title' => esc_html__('Header Type', 'industio'),
				            'options' => [
				            	'px-header--default'       	   => esc_html__('Default', 'industio'), 
								'px-header--transparent'       => esc_html__('Transparent', 'industio'),
								'px-header--left_sidebar'       => esc_html__('Left Sidebar', 'industio'),
				            ],
				            'default' => 'px-header--default',
				            'indent' => true,
                			'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'header' ),
				        ),

				        array(
							'id'    => 'header_mobile_type',
							'type'  => 'select',
							'title' => esc_html__('Header Type', 'industio'),
				            'options' => [
				            	'px-header--default'       	   => esc_html__('Default', 'industio'), 
								'px-header--transparent'       => esc_html__('Transparent', 'industio'),
				            ],
				            'default' => 'px-header--default',
				            'indent' => true,
                			'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'header-mobile' ),
				        ),

				        array(
							'id'    => 'hidden_panel_position',
							'type'  => 'select',
							'title' => esc_html__('Hidden Panel Position', 'industio'),
				            'options' => [
				            	'top'       	   => esc_html__('Top', 'industio'),
				            	'left'       	   => esc_html__('Left', 'industio'),
				            	'right'       	   => esc_html__('Right', 'industio'),
				            ],
				            'default' => 'right',
				            'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'hidden-panel' ),
				        ),
				        array(
				            'id'          => 'hidden_panel_height',
				            'type'        => 'text',
				            'title'       => esc_html__('Hidden Panel Height', 'industio'),
				            'subtitle'       => esc_html__('Enter number.', 'industio'),
				            'transparent' => false,
				            'default'     => '',
				            'force_output' => true,
				            'required' => array( 0 => 'hidden_panel_position', 1 => 'equals', 2 => 'top' ),
				        ),
				        array(
				            'id'          => 'hidden_panel_boxcolor',
				            'type'        => 'color',
				            'title'       => esc_html__('Box Color', 'industio'),
				            'transparent' => false,
				            'default'     => '',
				            'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'hidden-panel' ),
				        ),
				        array(
				            'id'          => 'header_sidebar_width',
				            'type'        => 'slider',
				            'title'       => esc_html__('Header Sidebar Width', 'industio'),
				            "default"   => 300,
						    "min"       => 50,
						    "step"      => 1,
						    "max"       => 900,
				            'force_output' => true,
				            'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'px-header--left_sidebar' ),
				        ),

				        array(
							'id'    => 'header_sidebar_style',
							'type'  => 'select',
							'title' => esc_html__('Header Sidebar Style', 'industio'),
				            'options' => [
				            	'px-header-sidebar-style1'      => esc_html__('Style 1', 'industio'), 
								'px-header-sidebar-style2'      => esc_html__('Style 2', 'industio'),
				            ],
				            'default' => 'px-header-sidebar-style1',
				            'indent' => true,
                			'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'px-header--left_sidebar' ),
				        ),
					),
				    
				],
			]
		],
	];
 
	$metabox->add_meta_data( $panels );
}
 