<?php
/**
 * @package Case-Themes
 */
$archive_readmore_text = industio()->get_theme_opt('archive_readmore_text', esc_html__('Read More', 'industio'));
$featured_img_size = industio()->get_theme_opt('featured_img_size', '960x460');
$img_url = '';
if (has_post_thumbnail(get_the_ID()) && wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), false)) {
    $img_url = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), false);
}

$post_video_link = get_post_meta(get_the_ID(), 'post_video_link', true);
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('pxl---post pxl-item--archive pxl-item--standard'); ?>>
    <?php if(has_post_format('gallery')) {
        $gallery_list = [];
        $gallery = get_post_meta( get_the_ID(), 'featured-gallery', true );
        $galleries = explode(',', $gallery);
         
        if(!empty($galleries)):
            if (!wp_script_is( 'swiper', 'enqueued' ))
                wp_enqueue_script( 'swiper');
            if (has_post_thumbnail()) {
                $featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'industio-archive'); 
                $gallery_list[] = $featured_img_url;
            }
            foreach ($galleries as $gal_id) {
                $gal_image_url = wp_get_attachment_image_url( $gal_id, 'industio-archive' );
                $gallery_list[] = $gal_image_url;
            }  
            echo '<div class="pxl-feature feature-gallery pxl-item--image">'; ?>
                <div class="inner-feature">
                    <div class="pxl-swiper-slider post-gallery-slider">
                        <div class="pxl-swiper-slider-wrap pxl-carousel-inner overflow-hidden">
                            <div class="pxl-swiper-container">
                                <div class="pxl-swiper-wrapper swiper-wrapper">
                                    <?php foreach ($gallery_list as $value): ?>
                                        <div class="pxl-swiper-slide swiper-slide">
                                            <img src="<?php echo esc_url($value)?>" alt="gallery">
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                        <div class="pxl-swiper-arrows">
                            <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><i class="icofont icofont-circled-left"></i></div>
                            <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><i class="icofont icofont-circled-right"></i></div>
                        </div>
                    </div>
                </div>
                <?php if($archive_category) : ?>
                    <div class="pxl-item--category"><i class="caseicon caseicon-folder"></i><?php the_terms( get_the_ID(), 'category', ' ', '' ); ?></div>
                <?php endif; ?>
            <?php echo '</div>'; ?>
        <?php elseif (has_post_thumbnail()):
            $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'industio-archive'); 
            echo '<div class="pxl-feature pxl-item--image">'; ?>
                <a href="<?php echo esc_url( get_permalink()); ?>">
                    <?php the_post_thumbnail('industio-archive'); ?>
                </a>
            <?php echo '</div>';
        endif; ?>
    <?php } else { ?>
        <?php if (has_post_thumbnail()) {
            echo '<div class="pxl-feature pxl-item--image">'; ?>
                <div class="inner-feature">
                    <a href="<?php echo esc_url( get_permalink()); ?>">
                        <?php the_post_thumbnail('industio-archive'); ?>
                    </a>
                    <?php if(!empty($post_video_link)) : ?>
                        <a href="<?php echo esc_url($post_video_link); ?>" class="post-button-video pxl-action-popup"><i class="caseicon-play1"></i></a>
                    <?php endif; ?>
                </div>
            <?php echo '</div>';
        } ?>
    <?php } ?>
    <div class="pxl-item--holder">
        <h2 class="pxl-item--title">
            <a href="<?php echo esc_url( get_permalink()); ?>" title="<?php the_title_attribute(); ?>">
                <?php if(is_sticky()) { ?>
                    <i class="caseicon-check-mark pxl-mr-4"></i>
                <?php } ?>
                <?php the_title(); ?>
            </a>
        </h2>
        <?php industio()->blog->get_archive_meta(); ?>
        <div class="pxl-item--excerpt">
            <?php
                industio()->blog->get_excerpt();
                wp_link_pages( array(
                    'before'      => '<div class="page-links">',
                    'after'       => '</div>',
                    'link_before' => '<span>',
                    'link_after'  => '</span>',
                ) );
            ?>
        </div>
        <div class="pxl-item--readmore">
            <a class="btn btn-icon-box" href="<?php echo esc_url( get_permalink()); ?>">
                <span class="pxl--btn-text"><?php echo industio_html($archive_readmore_text); ?></span>
                <span class="pxl--btn-icon"><i class="flaticon-up-right-arrow-1"></i></span>
            </a>
        </div>
    </div>
</article>